# -*- coding: utf-8 -*-
# Generated by Django 1.11.27 on 2020-05-29 02:52
from __future__ import unicode_literals

from django.db import migrations, models


def forward(apps, schema_editor):
    BusinessConstraint = apps.get_model("meeting", "BusinessConstraint")
    BusinessConstraint.objects.create(
        slug="bof_overlapping_prg",
        name="BOFs cannot conflict with PRGs",
        penalty=100000,
    )
    BusinessConstraint.objects.create(
        slug="bof_overlapping_bof",
        name="BOFs cannot conflict with any other BOFs",
        penalty=100000,
    )
    BusinessConstraint.objects.create(
        slug="bof_overlapping_area_wg",
        name="BOFs cannot conflict with any other WGs in their area",
        penalty=100000,
    )
    BusinessConstraint.objects.create(
        slug="bof_overlapping_area_meeting",
        name="BOFs cannot conflict with any area-wide meetings (of any area)",
        penalty=10000,
    )
    BusinessConstraint.objects.create(
        slug="area_overlapping_in_area",
        name="Area meetings cannot conflict with anything else in their area",
        penalty=10000,
    )
    BusinessConstraint.objects.create(
        slug="area_overlapping_other_area",
        name="Area meetings cannot conflict with other area meetings",
        penalty=100000,
    )
    BusinessConstraint.objects.create(
        slug="session_overlap_ad",
        name="WGs overseen by the same Area Director should not conflict",
        penalty=100,
    )
    BusinessConstraint.objects.create(
        slug="sessions_out_of_order",
        name="Sessions should be scheduled in requested order",
        penalty=100000,
    )
    BusinessConstraint.objects.create(
        slug="session_requires_trim",
        name="Sessions should be scheduled according to requested duration and attendees",
        penalty=100000,
    )
    
    ConstraintName = apps.get_model("name", "ConstraintName")
    ConstraintName.objects.filter(slug='conflict').update(penalty=100000)
    ConstraintName.objects.filter(slug='conflic2').update(penalty=10000)
    ConstraintName.objects.filter(slug='conflic3').update(penalty=100000)
    ConstraintName.objects.filter(slug='bethere').update(penalty=10000)
    ConstraintName.objects.filter(slug='timerange').update(penalty=1000000)
    ConstraintName.objects.filter(slug='time_relation').update(penalty=1000)
    ConstraintName.objects.filter(slug='wg_adjacent').update(penalty=1000)


def reverse(apps, schema_editor):
    ConstraintName = apps.get_model("name", "ConstraintName")
    ConstraintName.objects.filter(slug='conflict').update(penalty=100000)
    ConstraintName.objects.filter(slug='conflic2').update(penalty=10000)
    ConstraintName.objects.filter(slug='conflic3').update(penalty=1000)
    ConstraintName.objects.filter(slug='bethere').update(penalty=200000)
    ConstraintName.objects.filter(slug='timerange').update(penalty=100000)
    ConstraintName.objects.filter(slug='time_relation').update(penalty=100000)
    ConstraintName.objects.filter(slug='wg_adjacent').update(penalty=100000)


class Migration(migrations.Migration):

    dependencies = [
        ('meeting', '0028_auto_20200501_0139'),
    ]

    operations = [
        migrations.CreateModel(
            name='BusinessConstraint',
            fields=[
                ('slug', models.CharField(max_length=32, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('penalty', models.IntegerField(default=0, help_text='The penalty for violating this kind of constraint; for instance 10 (small penalty) or 10000 (large penalty)')),
            ],
        ),
        migrations.RunPython(forward, reverse),
    ]
