# Generated by Django 2.2.20 on 2021-05-20 12:30

from django.db import migrations
from django.db.models import IntegerField
from django.db.models.functions import Cast


def forward(apps, schema_editor):
    Meeting = apps.get_model('meeting', 'Meeting')
    ConstraintName = apps.get_model('name', 'ConstraintName')

    # old for pre-106
    old_constraints = ConstraintName.objects.filter(slug__in=['conflict', 'conflic2', 'conflic3'])
    new_constraints = ConstraintName.objects.filter(slug__in=['chair_conflict', 'tech_overlap', 'key_participant'])

    # get meetings with numeric 'number' field to avoid lexicographic ordering
    ietf_meetings = Meeting.objects.filter(
        type='ietf'
    ).annotate(
        number_as_int=Cast('number', output_field=IntegerField())
    )

    for mtg in ietf_meetings.filter(number_as_int__lt=106):
        for cn in old_constraints:
            mtg.group_conflict_types.add(cn)
    for mtg in ietf_meetings.filter(number_as_int__gte=106):
        for cn in new_constraints:
            mtg.group_conflict_types.add(cn)

def reverse(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('meeting', '0042_meeting_group_conflict_types'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
