# Generated by Django 2.2.20 on 2021-05-13 07:51

from django.db import migrations


replacement_slugs = (
    ('conflict', 'chair_conflict'),
    ('conflic2', 'tech_overlap'),
    ('conflic3', 'key_participant'),
)


def affected(constraint_qs):
    """Filter constraints, keeping only those to be updated"""
    # The constraints were renamed in the UI in commit 16699 on 2019-09-03.
    # This was between meetings 105 and 106. Assuming this migration and
    # the new conflict types are in place before meeting 111, these
    # are the meetings for which the UI disagreed with the constraint
    # type actually created.
    affected_meetings = ['111']
    return constraint_qs.filter(meeting__number__in=affected_meetings)


def forward(apps, schema_editor):
    Constraint = apps.get_model('meeting', 'Constraint')
    affected_constraints = affected(Constraint.objects.all())
    for old, new in replacement_slugs:
        affected_constraints.filter(name_id=old).update(name_id=new)


def reverse(apps, schema_editor):
    Constraint = apps.get_model('meeting', 'Constraint')
    affected_constraints = affected(Constraint.objects.all())
    for old, new in replacement_slugs:
        affected_constraints.filter(name_id=new).update(name_id=old)


class Migration(migrations.Migration):

    dependencies = [
        ('meeting', '0043_populate_meeting_group_conflict_types'),
        ('name', '0027_add_bofrequest'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
