# Generated by Django 2.2.24 on 2021-08-26 10:18

from django.db import migrations, models
import django.db.models.deletion
import ietf.meeting.models
import ietf.utils.fields
import ietf.utils.models
import ietf.utils.storage
import ietf.utils.validators


class Migration(migrations.Migration):

    dependencies = [
        ('meeting', '0045_proceedingsmaterial'),
    ]

    operations = [
        migrations.CreateModel(
            name='MeetingHost',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('logo', ietf.utils.fields.MissingOkImageField(height_field='logo_height', storage=ietf.utils.storage.NoLocationMigrationFileSystemStorage(location=None), upload_to=ietf.meeting.models._host_upload_path, validators=[ietf.utils.validators.MaxImageSizeValidator(1600, 1600), ietf.utils.validators.WrappedValidator(ietf.utils.validators.validate_file_size, True), ietf.utils.validators.WrappedValidator(ietf.utils.validators.validate_file_extension, ['.png', '.jpg', '.jpeg']), ietf.utils.validators.WrappedValidator(ietf.utils.validators.validate_mime_type, ['image/jpeg', 'image/png'], True)], width_field='logo_width')),
                ('logo_width', models.PositiveIntegerField(null=True)),
                ('logo_height', models.PositiveIntegerField(null=True)),
                ('meeting', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='meetinghosts', to='meeting.Meeting')),
            ],
            options={
                'ordering': ('pk',),
                'unique_together': {('meeting', 'name')},
            },
        ),
    ]
