# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2019-01-04 14:02


from django.db import migrations

def forward(apps, schema_editor):
    ReviewRequestStateName = apps.get_model('name','ReviewRequestStateName')
    ReviewAssignmentStateName = apps.get_model('name','ReviewAssignmentStateName')

    # TODO: Remove these newly unused states in a future release
    ReviewRequestStateName.objects.filter(slug__in=['accepted', 'rejected', 'no-response', 'part-completed', 'completed', 'unknown']).update(used=False)
    name, created = ReviewRequestStateName.objects.get_or_create(slug = 'assigned')
    if created:
        name.name = 'Assigned'
        name.desc = 'The ReviewRequest has been assigned to at least one reviewer'
        name.used = True
        name.order = 0
        name.save()

    assignment_states = [
        { 'slug': 'assigned',
          'name': 'Assigned',
          'desc': 'The review has been assigned to this reviewer',
          'used': True,
          'order': 0
        },
        { 'slug':'accepted', 
          'name':'Accepted', 
          'desc':'The reviewer has accepted the assignment', 
          'used': True, 
          'order':0 
        },
        { 'slug':'rejected', 
          'name':'Rejected', 
          'desc':'The reviewer has rejected the assignment', 
          'used': True, 
          'order':0 
        },
        { 'slug':'withdrawn', 
          'name':'Withdrawn by Team', 
          'desc':'The team secretary has withdrawn the assignment', 
          'used': True, 
          'order':0 
        },
        { 'slug':'overtaken', 
          'name':'Overtaken By Events', 
          'desc':'The review was abandoned because of circumstances', 
          'used': True, 
          'order':0 
        },
        { 'slug':'no-response', 
          'name':'No Response', 
          'desc':'The reviewer did not provide a review by the deadline', 
          'used': True, 
          'order':0 
        },
        { 'slug':'part-completed', 
          'name':'Partially Completed', 
          'desc':'The reviewer partially completed the assignment', 
          'used': True, 
          'order':0 
        },
        { 'slug':'completed', 
          'name':'Completed', 
          'desc':'The reviewer completed the assignment', 
          'used': True, 
          'order':0 
        },
        { 'slug':'unknown',
          'name':'Unknown',
          'desc':'The assignment is was imported from an earlier database and its state could not be computed',
          'used':'True',
          'order':0
        }
    ]

    for entry in assignment_states:
        name, created = ReviewAssignmentStateName.objects.get_or_create(slug=entry['slug'])
        if created:
            for k, v in entry.items():
                setattr(name, k, v)
            name.save()

def reverse(apps, schema_editor):
    ReviewRequestStateName = apps.get_model('name','ReviewRequestStateName')
    ReviewAssignmentStateName = apps.get_model('name','ReviewAssignmentStateName')
    ReviewRequestStateName.objects.filter(slug__in=['accepted', 'rejected', 'no-response', 'part-completed', 'completed', 'unknown']).update(used=True)
    ReviewRequestStateName.objects.filter(slug='assigned').update(used=False)
    ReviewAssignmentStateName.objects.update(used=False)
    

class Migration(migrations.Migration):

    dependencies = [
        ('name', '0005_reviewassignmentstatename'),
        ('doc','0011_reviewassignmentdocevent'),
    ]

    operations = [
        migrations.RunPython(forward, reverse)
    ]
