# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.23 on 2019-11-18 08:35


from django.db import migrations, models


class Migration(migrations.Migration):
    def forward(apps, schema_editor):
        ReviewerQueuePolicyName = apps.get_model('name', 'ReviewerQueuePolicyName')
        ReviewerQueuePolicyName.objects.create(slug='RotateAlphabetically', name='Rotate alphabetically')
        ReviewerQueuePolicyName.objects.create(slug='LeastRecentlyUsed', name='Least recently used')

    def reverse(self, apps):
        pass
    
    dependencies = [
        ('name', '0007_fix_m2m_slug_id_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='ReviewerQueuePolicyName',
            fields=[
                ('slug', models.CharField(max_length=32, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('desc', models.TextField(blank=True)),
                ('used', models.BooleanField(default=True)),
                ('order', models.IntegerField(default=0)),
            ],
            options={
                'ordering': ['order', 'name'],
                'abstract': False,
            },
        ),
        migrations.RunPython(forward, reverse),
    ]
