# Copyright The IETF Trust 2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.27 on 2020-02-04 05:43
from __future__ import unicode_literals

from django.db import migrations, models


def forward(apps, schema_editor):
    TimerangeName = apps.get_model('name', 'TimerangeName')
    timeranges = [
        ('monday-morning', 'Monday morning'),
        ('monday-afternoon-early', 'Monday early afternoon'),
        ('monday-afternoon-late', 'Monday late afternoon'),
        ('tuesday-morning', 'Tuesday morning'),
        ('tuesday-afternoon-early', 'Tuesday early afternoon'),
        ('tuesday-afternoon-late', 'Tuesday late afternoon'),
        ('wednesday-morning', 'Wednesday morning'),
        ('wednesday-afternoon-early', 'Wednesday early afternoon'),
        ('wednesday-afternoon-late', 'Wednesday late afternoon'),
        ('thursday-morning', 'Thursday morning'),
        ('thursday-afternoon-early', 'Thursday early afternoon'),
        ('thursday-afternoon-late', 'Thursday late afternoon'),
        ('friday-morning', 'Friday morning'),
        ('friday-afternoon-early', 'Friday early afternoon'),
        ('friday-afternoon-late', 'Friday late afternoon'),
    ]
    for order, (slug, desc) in enumerate(timeranges):
        TimerangeName.objects.create(slug=slug, name=slug, desc=desc, used=True, order=order)
        
        
def reverse(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('name', '0009_add_verified_errata_to_doctagname'),
    ]

    operations = [
        migrations.CreateModel(
            name='TimerangeName',
            fields=[
                ('slug', models.CharField(max_length=32, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('desc', models.TextField(blank=True)),
                ('used', models.BooleanField(default=True)),
                ('order', models.IntegerField(default=0)),
            ],
            options={
                'ordering': ['order', 'name'],
                'abstract': False,
            },
        ),
        migrations.RunPython(forward, reverse),
    ]
