# Copyright The IETF Trust 2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 2.0.13 on 2020-06-02 10:13

from django.db import migrations

def forward(apps, schema_editor):
    DocUrlTagName = apps.get_model('name', 'DocUrlTagName')
    DocUrlTagName.objects.create(
        slug='auth48',
        name='RFC Editor Auth48 status',
        used=True,
    )

def reverse(apps, schema_editor):
    DocUrlTagName = apps.get_model('name', 'DocUrlTagName')
    auth48_tag = DocUrlTagName.objects.get(slug='auth48')
    auth48_tag.delete()

class Migration(migrations.Migration):
    """Add DocUrlTagName entry for RFC Ed Auth48 URL"""
    dependencies = [
        ('name', '0012_role_name_robots'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
