# Generated by Django 2.2.15 on 2020-08-20 02:40

from django.db import migrations, models

def set_private_bit_on_timeslottypename(apps, schema_editor):
    TimeSlotTypeName = apps.get_model('name', 'TimeSlotTypeName')

    TimeSlotTypeName.objects.filter(slug__in=['lead', 'offagenda']).update(private=True)

def noop(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('name', '0018_slidesubmissionstatusname'),
    ]

    operations = [
        migrations.AddField(
            model_name='timeslottypename',
            name='private',
            field=models.BooleanField(default=False, help_text='Whether sessions of this type should be kept off the public agenda'),
        ),
        migrations.RunPython(set_private_bit_on_timeslottypename, noop),
    ]
