# Generated by Django 2.2.17 on 2020-12-09 07:02

from django.db import migrations


def forward(apps, schema_editor):
    """Perform forward migration
    
    Adds RoleNames for liaison contacts
    """
    RoleName = apps.get_model('name', 'RoleName')
    RoleName.objects.create(
        slug='liaison_contact',
        name='Liaison Contact',
    )
    RoleName.objects.create(
        slug='liaison_cc_contact',
        name='Liaison CC Contact',
    )
    

def reverse(apps, schema_editor):
    """Perform reverse migration
    
    Removes RoleNames for liaison contacts
    """
    RoleName = apps.get_model('name', 'RoleName')
    RoleName.objects.filter(
        slug__in=['liaison_contact', 'liaison_cc_contact']
    ).delete()

class Migration(migrations.Migration):

    dependencies = [
        ('name', '0021_add_ad_appr_draftsubmissionstatename'),
        ('group', '0040_lengthen_used_roles_fields'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
