# Generated by Django 2.2.20 on 2021-04-20 13:56

from django.db import migrations


def forward(apps, schema_editor):
    AgendaFilterTypeName = apps.get_model('name', 'AgendaFilterTypeName')
    names = (
        ('none', 'None', 'Not used except for a timeslot-type column (e.g., officehours)'),
        ('normal', 'Normal', 'Non-heading filter button'),
        ('heading', 'Heading', 'Column heading button'),
        ('special', 'Special', 'Button in the catch-all column'),
    )
    for order, (slug, name, desc) in enumerate(names):
        AgendaFilterTypeName.objects.get_or_create(
            slug=slug,
            defaults=dict(name=name, desc=desc, order=order, used=True)
        )


def reverse(apps, schema_editor):
    pass  # nothing to do, model about to be destroyed anyway


class Migration(migrations.Migration):

    dependencies = [
        ('name', '0032_agendafiltertypename'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
