# Copyright The IETF Trust 2021 All Rights Reserved

# Generated by Django 2.2.24 on 2021-09-16 09:42

from django.db import migrations


def forward(apps, schema_editor):
    SessionPurposeName = apps.get_model('name', 'SessionPurposeName')
    TimeSlotTypeName = apps.get_model('name', 'TimeSlotTypeName')

    for order, (slug, name, desc, tstypes, on_agenda, used) in enumerate((
            ('none', 'None', 'Value not set (do not use for new sessions)', [], True, False),
            ('regular', 'Regular', 'Regular group session', ['regular'], True, True),
            ('tutorial', 'Tutorial', 'Tutorial or training session', ['other'], True, True),
            ('officehours', 'Office hours', 'Office hours session', ['other'], True, True),
            ('coding', 'Coding', 'Coding session', ['other'], True, True),
            ('admin', 'Administrative', 'Meeting administration', ['other', 'reg'], True, True),
            ('social', 'Social', 'Social event or activity', ['break', 'other'], True, True),
            ('plenary', 'Plenary', 'Plenary session', ['plenary'], True, True),
            ('presentation', 'Presentation', 'Presentation session', ['other', 'regular'], True, True),
            ('open_meeting', 'Open meeting', 'Open meeting', ['other'], True, True),
            ('closed_meeting', 'Closed meeting', 'Closed meeting', ['other', 'regular'], False, True),
    )):
        # verify that we're not about to use an invalid type
        for ts_type in tstypes:
            TimeSlotTypeName.objects.get(pk=ts_type)  # throws an exception unless exists

        SessionPurposeName.objects.create(
            slug=slug,
            name=name,
            desc=desc,
            used=used,
            order=order,
            timeslot_types = tstypes,
            on_agenda=on_agenda,
        )


def reverse(apps, schema_editor):
    SessionPurposeName = apps.get_model('name', 'SessionPurposeName')
    SessionPurposeName.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('name', '0034_sessionpurposename'),
    ]

    operations = [
        migrations.RunPython(forward, reverse)
    ]
