# Generated by Django 2.2.24 on 2021-10-25 16:58

from django.db import migrations


PRIVATE_TIMESLOT_SLUGS = {'lead', 'offagenda'}  # from DB 2021 Oct


def forward(apps, schema_editor):
    TimeSlotTypeName = apps.get_model('name', 'TimeSlotTypeName')
    slugs = TimeSlotTypeName.objects.filter(private=True).values_list('slug', flat=True)
    if set(slugs) != PRIVATE_TIMESLOT_SLUGS:
        # the reverse migration will not restore the database, refuse to migrate
        raise ValueError('Disagreement between migration data and database')


def reverse(apps, schema_editor):
    TimeSlotTypeName = apps.get_model('name', 'TimeSlotTypeName')
    TimeSlotTypeName.objects.filter(slug__in=PRIVATE_TIMESLOT_SLUGS).update(private=True)


class Migration(migrations.Migration):

    dependencies = [
        ('name', '0035_populate_sessionpurposename'),
        ('meeting', '0051_populate_session_on_agenda'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
