# Copyright The IETF Trust 2018-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-02-20 10:52


import datetime
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import ietf.person.models
import ietf.utils.models
import ietf.utils.storage


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Alias',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=255)),
            ],
            options={
                'verbose_name_plural': 'Aliases',
            },
        ),
        migrations.CreateModel(
            name='Email',
            fields=[
                ('address', models.CharField(max_length=64, primary_key=True, serialize=False, validators=[django.core.validators.EmailValidator()])),
                ('time', models.DateTimeField(auto_now_add=True)),
                ('primary', models.BooleanField(default=False)),
                ('active', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(default=datetime.datetime.now)),
                ('name', models.CharField(db_index=True, help_text='Preferred form of name.', max_length=255, verbose_name='Full Name (Unicode)')),
                ('ascii', models.CharField(help_text='Name as rendered in ASCII (Latin, unaccented) characters.', max_length=255, verbose_name='Full Name (ASCII)')),
                ('ascii_short', models.CharField(blank=True, help_text='Example: A. Nonymous.  Fill in this with initials and surname only if taking the initials and surname of the ASCII name above produces an incorrect initials-only form. (Blank is OK).', max_length=32, null=True, verbose_name='Abbreviated Name (ASCII)')),
                ('affiliation', models.CharField(blank=True, help_text='Employer, university, sponsor, etc.', max_length=255)),
                ('address', models.TextField(blank=True, help_text='Postal mailing address.', max_length=255)),
                ('biography', models.TextField(blank=True, help_text='Short biography for use on leadership pages. Use plain text or reStructuredText markup.')),
                ('photo', models.ImageField(blank=True, default=None, storage=ietf.utils.storage.NoLocationMigrationFileSystemStorage(location=None), upload_to='photo')),
                ('photo_thumb', models.ImageField(blank=True, default=None, storage=ietf.utils.storage.NoLocationMigrationFileSystemStorage(location=None), upload_to='photo')),
                ('user', ietf.utils.models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PersonalApiKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('endpoint', models.CharField(choices=[('/api/iesg/position', '/api/iesg/position')], max_length=128)),
                ('created', models.DateTimeField(default=datetime.datetime.now)),
                ('valid', models.BooleanField(default=True)),
                ('salt', models.BinaryField(default=ietf.person.models.salt, max_length=12)),
                ('count', models.IntegerField(default=0)),
                ('latest', models.DateTimeField(blank=True, null=True)),
                ('person', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='apikeys', to='person.Person')),
            ],
        ),
        migrations.CreateModel(
            name='PersonEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(default=datetime.datetime.now, help_text='When the event happened')),
                ('type', models.CharField(choices=[('apikey_login', 'API key login')], max_length=50)),
                ('desc', models.TextField()),
            ],
            options={
                'ordering': ['-time', '-id'],
            },
        ),
        migrations.CreateModel(
            name='PersonHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(default=datetime.datetime.now)),
                ('name', models.CharField(db_index=True, help_text='Preferred form of name.', max_length=255, verbose_name='Full Name (Unicode)')),
                ('ascii', models.CharField(help_text='Name as rendered in ASCII (Latin, unaccented) characters.', max_length=255, verbose_name='Full Name (ASCII)')),
                ('ascii_short', models.CharField(blank=True, help_text='Example: A. Nonymous.  Fill in this with initials and surname only if taking the initials and surname of the ASCII name above produces an incorrect initials-only form. (Blank is OK).', max_length=32, null=True, verbose_name='Abbreviated Name (ASCII)')),
                ('affiliation', models.CharField(blank=True, help_text='Employer, university, sponsor, etc.', max_length=255)),
                ('address', models.TextField(blank=True, help_text='Postal mailing address.', max_length=255)),
                ('biography', models.TextField(blank=True, help_text='Short biography for use on leadership pages. Use plain text or reStructuredText markup.')),
                ('photo', models.ImageField(blank=True, default=None, storage=ietf.utils.storage.NoLocationMigrationFileSystemStorage(location=None), upload_to='photo')),
                ('photo_thumb', models.ImageField(blank=True, default=None, storage=ietf.utils.storage.NoLocationMigrationFileSystemStorage(location=None), upload_to='photo')),
                ('person', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='history_set', to='person.Person')),
                ('user', ietf.utils.models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PersonApiKeyEvent',
            fields=[
                ('personevent_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='person.PersonEvent')),
                ('key', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='person.PersonalApiKey')),
            ],
            bases=('person.personevent',),
        ),
        migrations.AddField(
            model_name='personevent',
            name='person',
            field=ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='person.Person'),
        ),
        migrations.AddField(
            model_name='email',
            name='person',
            field=ietf.utils.models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='person.Person'),
        ),
        migrations.AddField(
            model_name='alias',
            name='person',
            field=ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='person.Person'),
        ),
    ]
