# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2019-01-04 14:27


from django.db import migrations, models
import django.db.models.deletion
import ietf.utils.models


class Migration(migrations.Migration):

    dependencies = [
        ('doc', '0009_move_non_url_externalurls_to_uploaded_filename'),
        ('name', '0005_reviewassignmentstatename'),
        ('person', '0008_auto_20181014_1448'),
        ('review', '0008_remove_reviewrequest_old_id'),
    ]

    operations = [
        migrations.CreateModel(
            name='ReviewAssignment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('assigned_on', models.DateTimeField(blank=True, null=True)),
                ('completed_on', models.DateTimeField(blank=True, null=True)),
                ('reviewed_rev', models.CharField(blank=True, max_length=16, verbose_name='reviewed revision')),
                ('mailarch_url', models.URLField(blank=True, null=True)),
                ('result', ietf.utils.models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='name.ReviewResultName')),
                ('review', ietf.utils.models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='doc.Document')),
            ],
        ),
        migrations.RenameField(
            model_name='reviewrequest',
            old_name='result',
            new_name='unused_result',
        ),
        migrations.RenameField(
            model_name='reviewrequest',
            old_name='review',
            new_name='unused_review',
        ),
        migrations.RenameField(
            model_name='reviewrequest',
            old_name='reviewed_rev',
            new_name='unused_reviewed_rev',
        ),
        migrations.RenameField(
            model_name='reviewrequest',
            old_name='reviewer',
            new_name='unused_reviewer',
        ),
        migrations.AddField(
            model_name='reviewassignment',
            name='review_request',
            field=ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='review.ReviewRequest'),
        ),
        migrations.AddField(
            model_name='reviewassignment',
            name='reviewer',
            field=ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='person.Email'),
        ),
        migrations.AddField(
            model_name='reviewassignment',
            name='state',
            field=ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='name.ReviewAssignmentStateName'),
        ),
    ]
