# Copyright The IETF Trust 2018-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-02-20 10:52


import datetime
from django.db import migrations, models
import django.db.models.deletion
import ietf.utils.accesstoken
import ietf.utils.models
import jsonfield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('message', '0001_initial'),
        ('group', '0001_initial'),
        ('name', '0001_initial'),
        ('person', '0001_initial'),
        ('doc', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Preapproval',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=255)),
                ('time', models.DateTimeField(default=datetime.datetime.now)),
                ('by', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='person.Person')),
            ],
        ),
        migrations.CreateModel(
            name='Submission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('remote_ip', models.CharField(blank=True, max_length=100)),
                ('access_key', models.CharField(default=ietf.utils.accesstoken.generate_random_key, max_length=255)),
                ('auth_key', models.CharField(blank=True, max_length=255)),
                ('name', models.CharField(db_index=True, max_length=255)),
                ('title', models.CharField(blank=True, max_length=255)),
                ('abstract', models.TextField(blank=True)),
                ('rev', models.CharField(blank=True, max_length=3)),
                ('pages', models.IntegerField(blank=True, null=True)),
                ('words', models.IntegerField(blank=True, null=True)),
                ('authors', jsonfield.fields.JSONField(default=list, help_text='List of authors with name, email, affiliation and country.')),
                ('note', models.TextField(blank=True)),
                ('replaces', models.CharField(blank=True, max_length=1000)),
                ('first_two_pages', models.TextField(blank=True)),
                ('file_types', models.CharField(blank=True, max_length=50)),
                ('file_size', models.IntegerField(blank=True, null=True)),
                ('document_date', models.DateField(blank=True, null=True)),
                ('submission_date', models.DateField(default=datetime.date.today)),
                ('submitter', models.CharField(blank=True, help_text='Name and email of submitter, e.g. "John Doe &lt;john@example.org&gt;".', max_length=255)),
                ('draft', ietf.utils.models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='doc.Document')),
                ('formal_languages', models.ManyToManyField(blank=True, help_text='Formal languages used in document', to='name.FormalLanguageName')),
                ('group', ietf.utils.models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='group.Group')),
                ('state', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='name.DraftSubmissionStateName')),
            ],
        ),
        migrations.CreateModel(
            name='SubmissionCheck',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(default=datetime.datetime.now)),
                ('checker', models.CharField(blank=True, max_length=256)),
                ('passed', models.NullBooleanField(default=False)),
                ('message', models.TextField(blank=True, null=True)),
                ('errors', models.IntegerField(blank=True, default=None, null=True)),
                ('warnings', models.IntegerField(blank=True, default=None, null=True)),
                ('items', jsonfield.fields.JSONField(blank=True, default='{}', null=True)),
                ('symbol', models.CharField(default='', max_length=64)),
                ('submission', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='checks', to='submit.Submission')),
            ],
        ),
        migrations.CreateModel(
            name='SubmissionEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(default=datetime.datetime.now)),
                ('desc', models.TextField()),
            ],
            options={
                'ordering': ('-time', '-id'),
            },
        ),
        migrations.CreateModel(
            name='SubmissionEmailEvent',
            fields=[
                ('submissionevent_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='submit.SubmissionEvent')),
                ('msgtype', models.CharField(max_length=25)),
                ('in_reply_to', ietf.utils.models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='irtomanual', to='message.Message')),
                ('message', ietf.utils.models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='manualevents', to='message.Message')),
            ],
            options={
                'ordering': ['-time', '-id'],
            },
            bases=('submit.submissionevent',),
        ),
        migrations.AddField(
            model_name='submissionevent',
            name='by',
            field=ietf.utils.models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='person.Person'),
        ),
        migrations.AddField(
            model_name='submissionevent',
            name='submission',
            field=ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='submit.Submission'),
        ),
    ]
