/*
 * Copyright (c) 2022 Henry 李恒 (henry.box@outlook.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package pub.ihub.core;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

/**
 * @author liheng
 */
@DisplayName("通用业务异常测试")
class BusinessExceptionTest {

	@DisplayName("异常构造方法测试")
	@Test
	void builder() {
		assertEquals("message", new BusinessException("message").getMessage());
		assertEquals("message", new BusinessException("message", new RuntimeException()).getMessage());
		assertEquals("java.lang.RuntimeException", new BusinessException(new RuntimeException()).getMessage());
	}

}
