-- -------------------------------------------------------------------------------------------------
-- Database Name: mosip_keymgr
-- Table Name 	: keymgr.tsp_licensekey_map
-- Purpose    	: TSP License keys : TSP and License key mapping.
--           
-- Create By   	: Sadanandegowda DM
-- Created Date	: Sep-2020
-- 
-- Modified Date        Modified By         Comments / Remarks
-- ------------------------------------------------------------------------------------------
-- Jan-2021		Ram Bhatt	    Set is_deleted flag to not null and default false
-- Mar-2021		Ram Bhatt	    Reverting is_deleted not null changes
-- ------------------------------------------------------------------------------------------

-- object: keymgr.tsp_licensekey_map | type: TABLE --
-- DROP TABLE IF EXISTS keymgr.tsp_licensekey_map CASCADE;
CREATE TABLE keymgr.tsp_licensekey_map(
	tsp_id character varying(36) NOT NULL,
	license_key character varying(255) NOT NULL,
	is_active boolean NOT NULL,
	cr_by character varying(256) NOT NULL,
	cr_dtimes timestamp NOT NULL,
	upd_by character varying(256),
	upd_dtimes timestamp,
	is_deleted boolean DEFAULT FALSE,
	del_dtimes timestamp,
	CONSTRAINT pk_tsplkeym PRIMARY KEY (tsp_id,license_key)

);
-- ddl-end --
COMMENT ON TABLE keymgr.tsp_licensekey_map IS 'TSP License keys : TSP and License key mapping';
-- ddl-end --
COMMENT ON COLUMN keymgr.tsp_licensekey_map.tsp_id IS 'TSP ID: ID of the thirdparty service provider';
-- ddl-end --
COMMENT ON COLUMN keymgr.tsp_licensekey_map.license_key IS 'License Key : License key which is mapped to TSP, This will refer to master.licensekey_list.license_key';
-- ddl-end --
COMMENT ON COLUMN keymgr.tsp_licensekey_map.is_active IS 'Flag to mark whether the record is Active or In-active';
-- ddl-end --
COMMENT ON COLUMN keymgr.tsp_licensekey_map.cr_by IS 'Created By : ID or name of the user who create / insert record';
-- ddl-end --
COMMENT ON COLUMN keymgr.tsp_licensekey_map.cr_dtimes IS 'Created DateTimestamp : Date and Timestamp when the record is created/inserted';
-- ddl-end --
COMMENT ON COLUMN keymgr.tsp_licensekey_map.upd_by IS 'Updated By : ID or name of the user who update the record with new values';
-- ddl-end --
COMMENT ON COLUMN keymgr.tsp_licensekey_map.upd_dtimes IS 'Updated DateTimestamp : Date and Timestamp when any of the fields in the record is updated with new values.';
-- ddl-end --
COMMENT ON COLUMN keymgr.tsp_licensekey_map.is_deleted IS 'IS_Deleted : Flag to mark whether the record is Soft deleted.';
-- ddl-end --
COMMENT ON COLUMN keymgr.tsp_licensekey_map.del_dtimes IS 'Deleted DateTimestamp : Date and Timestamp when the record is soft deleted with is_deleted=TRUE''';
-- ddl-end --
