package io.mosip.kernel.core.test.util;

import static org.junit.Assert.assertTrue;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.zip.ZipException;

import org.junit.After;
import org.junit.Test;

import io.mosip.kernel.core.exception.FileNotFoundException;
import io.mosip.kernel.core.exception.IOException;
import io.mosip.kernel.core.util.ZipUtils;

/**
 * Test class for ZipUtil class
 * 
 * @author Megha Tanga
 * @since 1.0.0
 *
 */
public class ZipUtilTest {

	@After
	public void cleanup() {
		File dir = new File("unzip");
		if (dir.exists()) {

			String[] entries = dir.list();
			for (String s : entries) {
				File currentFile = new File(dir.getPath(), s);
				if (currentFile.isDirectory()) {
					String[] innerEntries = currentFile.list();
					for (String s1 : innerEntries) {
						File innerCurrentFile = new File(currentFile.getPath(), s1);
						innerCurrentFile.delete();
					}
				}
				currentFile.delete();
			}
			dir.delete();
		}
	}

	public static ZipUtils zip;

	@Test
	public void zipByteArray() throws FileNotFoundException, IOException, java.io.IOException, URISyntaxException {

		byte[] data = Files
				.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource("SampleFile.txt").toURI()));
		byte[] returnedzippedByteArray = ZipUtils.zipByteArray(data);
		String outputFile = "compressedByteArray.zip";
		Files.write(Paths.get(outputFile), returnedzippedByteArray);
		File returnFile = new File(outputFile);

		assertTrue(returnFile.exists());
		File file = new File(outputFile);
		file.delete();
	}

	@Test
	public void unzipByteArray() throws FileNotFoundException, IOException, java.io.IOException, URISyntaxException {

		byte[] data = Files
				.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource("SampleFile.txt").toURI()));
		byte[] returnedzippedByteArray = ZipUtils.zipByteArray(data);
		String finalPath = "final.txt";

		byte[] returnedunzipByteArray = ZipUtils.unzipByteArray(returnedzippedByteArray);
		Files.write(Paths.get(finalPath), returnedunzipByteArray);
		File returnFile = new File(finalPath);

		assertTrue(returnFile.exists());
		File file = new File(finalPath);
		file.delete();
	}

	/*
	 * @Test public void zipFileTest() throws FileNotFoundException, IOException,
	 * java.io.IOException {
	 * 
	 * String outputFile = "compressed.zip"; ClassLoader classLoader =
	 * getClass().getClassLoader(); String inputFile =
	 * classLoader.getResource("SampleFile.txt").getFile(); boolean ren =
	 * ZipUtils.zipFile(inputFile, outputFile); assertTrue(ren);
	 * 
	 * File file = new File(outputFile); file.delete(); }
	 */

	/*
	 * @Test(expected = FileNotFoundException.class) public void
	 * zipFileFileNotFoundExceptionTestWithInputFile() throws FileNotFoundException,
	 * IOException { String inputFile = null; String outputFile = "";
	 * ZipUtils.zipFile(inputFile, outputFile); }
	 */

	/*
	 * @Test public void zipMultipleFileTest() throws FileNotFoundException,
	 * IOException {
	 * 
	 * ClassLoader classLoader = getClass().getClassLoader(); String inputMultFile1
	 * = classLoader.getResource("File1.txt").getFile(); String inputMultFile2 =
	 * classLoader.getResource("File2.txt").getFile(); String outputMulFile =
	 * "compressedMulty.zip"; String[] inputMultFile = { inputMultFile1,
	 * inputMultFile2 };
	 * 
	 * boolean ren = ZipUtils.zipMultipleFile(inputMultFile, outputMulFile);
	 * assertTrue(ren);
	 * 
	 * File file = new File(outputMulFile); file.delete(); }
	 */
	/*
	 * @Test(expected = FileNotFoundException.class) public void
	 * zipMultFileNotFoundExceptionTest() throws FileNotFoundException, IOException
	 * { String[] inputMultFile = { "" }; String outputMulFile = "";
	 * 
	 * ZipUtils.zipMultipleFile(inputMultFile, outputMulFile); }
	 */

	/*
	 * @Test public void zipDirectoryTest() throws FileNotFoundException,
	 * IOException {
	 * 
	 * String outputDir = "compressedDir.zip"; ClassLoader classLoader =
	 * getClass().getClassLoader(); String inputDir =
	 * classLoader.getResource("test").getFile();
	 * 
	 * boolean ren = ZipUtils.zipDirectory(inputDir, outputDir); assertTrue(ren);
	 * 
	 * File file = new File(outputDir); file.delete(); }
	 */

	/*
	 * @Test(expected = FileNotFoundException.class) public void
	 * zipDirFileNotFoundExceptionTest() throws FileNotFoundException, IOException {
	 * String inputDir = ""; String outputDir = "";
	 * 
	 * ZipUtils.zipDirectory(inputDir, outputDir); }
	 */

	/*
	 * @Test public void unZipFileTest() throws FileNotFoundException, IOException {
	 * 
	 * String outputUnZip = "unzip"; ClassLoader classLoader =
	 * getClass().getClassLoader(); String inputZipFile =
	 * classLoader.getResource("File1.zip").getFile();
	 * 
	 * boolean ren = ZipUtils.unZipFile(inputZipFile, outputUnZip); assertTrue(ren);
	 * 
	 * File file = new File(outputUnZip + "File1.txt"); file.delete(); }
	 */

	/*
	 * @Test(expected = FileNotFoundException.class) public void
	 * unZipFileNotFoundExceptionTest() throws FileNotFoundException, IOException {
	 * 
	 * String inputZipFile = ""; String outputUnZip = "";
	 * ZipUtils.unZipFile(inputZipFile, outputUnZip); }
	 */

	/*
	 * @Test(expected = NullPointerException.class) public void
	 * unZipNullPointerException() throws FileNotFoundException, IOException {
	 * 
	 * String inputZipFile = null; String outputUnZip = null;
	 * ZipUtils.unZipFile(inputZipFile, outputUnZip); }
	 */

	// @Test
	public void unzipDTest() throws Exception {

		String outputUnZip = "unzip";
		ClassLoader classLoader = getClass().getClassLoader();
		String zipFile = classLoader.getResource("test.zip").getFile();

		boolean ren = ZipUtils.unZipDirectory(zipFile, outputUnZip);
		assertTrue(ren);

		File dir = new File(outputUnZip);
		String[] entries = dir.list();
		for (String s : entries) {
			File currentFile = new File(dir.getPath(), s);
			if (currentFile.isDirectory()) {
				String[] innerEntries = currentFile.list();
				for (String s1 : innerEntries) {
					File innerCurrentFile = new File(currentFile.getPath(), s1);
					innerCurrentFile.delete();
				}
			}
			currentFile.delete();
		}
		dir.delete();
	}

	@Test
	public void unZipTest() throws Exception {

		String outputUnZip = "unzip";
		ClassLoader classLoader = getClass().getClassLoader();
		String zipFile = classLoader.getResource("test.zip").getFile();

		boolean ren = ZipUtils.unZipDirectory(zipFile, outputUnZip, 15, 200000, 10);
		assertTrue(ren);

		File dir = new File(outputUnZip);
		String[] entries = dir.list();
		for (String s : entries) {
			File currentFile = new File(dir.getPath(), s);
			if (currentFile.isDirectory()) {
				String[] innerEntries = currentFile.list();
				for (String s1 : innerEntries) {
					File innerCurrentFile = new File(currentFile.getPath(), s1);
					innerCurrentFile.delete();
				}
			}
			currentFile.delete();
		}
		dir.delete();
	}

	@Test(expected = ZipException.class)
	public void unZipSlipTest() throws Exception {
		String outputUnZip = "../../unzip";
		ClassLoader classLoader = getClass().getClassLoader();
		String zipFile = classLoader.getResource("test.zip").getFile();
		ZipUtils.unZipDirectory(zipFile, outputUnZip, 15, 200000, 10);
		File dir = new File(outputUnZip);
		String[] entries = dir.list();
		for (String s : entries) {
			File currentFile = new File(dir.getPath(), s);
			if (currentFile.isDirectory()) {
				String[] innerEntries = currentFile.list();
				for (String s1 : innerEntries) {
					File innerCurrentFile = new File(currentFile.getPath(), s1);
					innerCurrentFile.delete();
				}
			}
			currentFile.delete();
		}
		dir.delete();
	}

	@Test(expected = IOException.class)
	public void unZipBombTest() throws Exception {
		String outputUnZip = "unzip";
		ClassLoader classLoader = getClass().getClassLoader();
		String zipFile = classLoader.getResource("zipbomb.zip").getFile();
		ZipUtils.unZipDirectory(zipFile, outputUnZip, 15, 200000, 10);
		File dir = new File(outputUnZip);
		String[] entries = dir.list();
		for (String s : entries) {
			File currentFile = new File(dir.getPath(), s);
			if (currentFile.isDirectory()) {
				String[] innerEntries = currentFile.list();
				for (String s1 : innerEntries) {
					File innerCurrentFile = new File(currentFile.getPath(), s1);
					innerCurrentFile.delete();
				}
			}
			currentFile.delete();
		}
		dir.delete();
	}

	@Test(expected = IOException.class)
	public void unZipSizeTest() throws Exception {
		String outputUnZip = "unzip";
		ClassLoader classLoader = getClass().getClassLoader();
		String zipFile = classLoader.getResource("test.zip").getFile();
		ZipUtils.unZipDirectory(zipFile, outputUnZip, 15, 200, 10);
		File dir = new File(outputUnZip);
		String[] entries = dir.list();
		for (String s : entries) {
			File currentFile = new File(dir.getPath(), s);
			if (currentFile.isDirectory()) {
				String[] innerEntries = currentFile.list();
				for (String s1 : innerEntries) {
					File innerCurrentFile = new File(currentFile.getPath(), s1);
					innerCurrentFile.delete();
				}
			}
			currentFile.delete();
		}
		dir.delete();
	}

	@Test(expected = IOException.class)
	public void unZipEntriesTest() throws Exception {
		String outputUnZip = "unzip";
		ClassLoader classLoader = getClass().getClassLoader();
		String zipFile = classLoader.getResource("test.zip").getFile();
		ZipUtils.unZipDirectory(zipFile, outputUnZip, 2, 200000, 10);
		File dir = new File(outputUnZip);
		String[] entries = dir.list();
		for (String s : entries) {
			File currentFile = new File(dir.getPath(), s);
			if (currentFile.isDirectory()) {
				String[] innerEntries = currentFile.list();
				for (String s1 : innerEntries) {
					File innerCurrentFile = new File(currentFile.getPath(), s1);
					innerCurrentFile.delete();
				}
			}
			currentFile.delete();
		}
		dir.delete();
	}

	@Test(expected = IOException.class)
	public void unZipDirextoryNotFoundExceptionTest() throws Exception {
		String outputUnZip = "";
		ZipUtils.unZipDirectory("", "", 15, 200000, 10);
		File dir = new File(outputUnZip);
		String[] entries = dir.list();
		for (String s : entries) {
			File currentFile = new File(dir.getPath(), s);
			if (currentFile.isDirectory()) {
				String[] innerEntries = currentFile.list();
				for (String s1 : innerEntries) {
					File innerCurrentFile = new File(currentFile.getPath(), s1);
					innerCurrentFile.delete();
				}
			}
			currentFile.delete();
		}
		dir.delete();
	}

	@Test(expected = IOException.class)
	public void unZipDirNotFoundExceptionTest() throws Exception {
		String outputFile = "";
		String outputUnZip = "";
		ZipUtils.unZipDirectory(outputFile, outputUnZip);
	}

}
