package robot

import (
	"context"
	"github.com/iimeta/iim-server/internal/dao"
	"github.com/iimeta/iim-server/internal/errors"
	"github.com/iimeta/iim-server/internal/model"
	"github.com/iimeta/iim-server/internal/service"
	"github.com/iimeta/iim-server/utility/logger"
	"go.mongodb.org/mongo-driver/mongo"
)

type sRobot struct{}

func init() {
	service.RegisterRobot(New())
}

func New() service.IRobot {
	return &sRobot{}
}

func (s *sRobot) GetRobotByUserId(ctx context.Context, userId int) (*model.Robot, error) {

	robot, err := dao.Robot.GetRobotByUserId(ctx, userId)
	if err != nil && !errors.Is(err, mongo.ErrNoDocuments) {
		logger.Error(ctx, err)
		return nil, err
	}

	if robot == nil {
		return nil, nil
	}

	return &model.Robot{
		UserId:    robot.UserId,
		RobotName: robot.RobotName,
		Describe:  robot.Describe,
		Logo:      robot.Logo,
		IsTalk:    robot.IsTalk,
		Status:    robot.Status,
		Type:      robot.Type,
		Company:   robot.Company,
		Model:     robot.Model,
		ModelType: robot.ModelType,
		Role:      robot.Role,
		Prompt:    robot.Prompt,
		MsgType:   robot.MsgType,
		Proxy:     robot.Proxy,
		CreatedAt: robot.CreatedAt,
		UpdatedAt: robot.UpdatedAt,
	}, nil
}
