package rpm

// See:
// https://github.com/rpm-software-management/rpm/blob/master/lib/rpmtag.h

// Tags for the signature header.
const (
	RPMSIGTAG_SIZE            = 1000
	RPMSIGTAG_LEMD5_1         = 1001
	RPMSIGTAG_PGP             = 1002
	RPMSIGTAG_LEMD5_2         = 1003
	RPMSIGTAG_MD5             = 1004
	RPMSIGTAG_GPG             = 1005
	RPMSIGTAG_PGP5            = 1006
	RPMSIGTAG_PAYLOADSIZE     = 1007
	RPMSIGTAG_RESERVEDSPACE   = 1008
	RPMSIGTAG_BADSHA1_1       = RPMTAG_BADSHA1_1
	RPMSIGTAG_BADSHA1_2       = RPMTAG_BADSHA1_2
	RPMSIGTAG_SHA1            = RPMTAG_SHA1HEADER
	RPMSIGTAG_DSA             = RPMTAG_DSAHEADER
	RPMSIGTAG_RSA             = RPMTAG_RSAHEADER
	RPMSIGTAG_LONGSIZE        = RPMTAG_LONGSIGSIZE
	RPMSIGTAG_LONGARCHIVESIZE = RPMTAG_LONGARCHIVESIZE
)

// Tags for the header header.
const (
	RPMTAG_NOT_FOUND = -1

	RPMTAG_HEADERIMAGE      = 61
	RPMTAG_HEADERSIGNATURES = 62
	RPMTAG_HEADERIMMUTABLE  = 63
	RPMTAG_HEADERREGIONS    = 64
	RPMTAG_HEADERI18NTABLE  = 100

	RPMTAG_SIG_BASE   = 256
	RPMTAG_SIGSIZE    = 257
	RPMTAG_SIGLEMD5_1 = 258
	RPMTAG_SIGPGP     = 259
	RPMTAG_SIGLEMD5_2 = 260
	RPMTAG_SIGMD5     = 261
	RPMTAG_PKGID      = RPMTAG_SIGMD5
	RPMTAG_SIGGPG     = 262
	RPMTAG_SIGPGP5    = 263

	RPMTAG_BADSHA1_1       = 264
	RPMTAG_BADSHA1_2       = 265
	RPMTAG_PUBKEYS         = 266
	RPMTAG_DSAHEADER       = 267
	RPMTAG_RSAHEADER       = 268
	RPMTAG_SHA1HEADER      = 269
	RPMTAG_HDRID           = RPMTAG_SHA1HEADER
	RPMTAG_LONGSIGSIZE     = 270
	RPMTAG_LONGARCHIVESIZE = 271

	RPMTAG_NAME               = 1000
	RPMTAG_N                  = RPMTAG_NAME
	RPMTAG_VERSION            = 1001
	RPMTAG_V                  = RPMTAG_VERSION
	RPMTAG_RELEASE            = 1002
	RPMTAG_R                  = RPMTAG_RELEASE
	RPMTAG_EPOCH              = 1003
	RPMTAG_E                  = RPMTAG_EPOCH
	RPMTAG_SUMMARY            = 1004
	RPMTAG_DESCRIPTION        = 1005
	RPMTAG_BUILDTIME          = 1006
	RPMTAG_BUILDHOST          = 1007
	RPMTAG_INSTALLTIME        = 1008
	RPMTAG_SIZE               = 1009
	RPMTAG_DISTRIBUTION       = 1010
	RPMTAG_VENDOR             = 1011
	RPMTAG_GIF                = 1012
	RPMTAG_XPM                = 1013
	RPMTAG_LICENSE            = 1014
	RPMTAG_PACKAGER           = 1015
	RPMTAG_GROUP              = 1016
	RPMTAG_CHANGELOG          = 1017
	RPMTAG_SOURCE             = 1018
	RPMTAG_PATCH              = 1019
	RPMTAG_URL                = 1020
	RPMTAG_OS                 = 1021
	RPMTAG_ARCH               = 1022
	RPMTAG_PREIN              = 1023
	RPMTAG_POSTIN             = 1024
	RPMTAG_PREUN              = 1025
	RPMTAG_POSTUN             = 1026
	RPMTAG_OLDFILENAMES       = 1027
	RPMTAG_FILESIZES          = 1028
	RPMTAG_FILESTATES         = 1029
	RPMTAG_FILEMODES          = 1030
	RPMTAG_FILEUIDS           = 1031
	RPMTAG_FILEGIDS           = 1032
	RPMTAG_FILERDEVS          = 1033
	RPMTAG_FILEMTIMES         = 1034
	RPMTAG_FILEDIGESTS        = 1035
	RPMTAG_FILEMD5S           = RPMTAG_FILEDIGESTS
	RPMTAG_FILELINKTOS        = 1036
	RPMTAG_FILEFLAGS          = 1037
	RPMTAG_ROOT               = 1038
	RPMTAG_FILEUSERNAME       = 1039
	RPMTAG_FILEGROUPNAME      = 1040
	RPMTAG_EXCLUDE            = 1041
	RPMTAG_EXCLUSIVE          = 1042
	RPMTAG_ICON               = 1043
	RPMTAG_SOURCERPM          = 1044
	RPMTAG_FILEVERIFYFLAGS    = 1045
	RPMTAG_ARCHIVESIZE        = 1046
	RPMTAG_PROVIDENAME        = 1047
	RPMTAG_PROVIDES           = RPMTAG_PROVIDENAME
	RPMTAG_P                  = RPMTAG_PROVIDENAME
	RPMTAG_REQUIREFLAGS       = 1048
	RPMTAG_REQUIRENAME        = 1049
	RPMTAG_REQUIRES           = RPMTAG_REQUIRENAME
	RPMTAG_REQUIREVERSION     = 1050
	RPMTAG_NOSOURCE           = 1051
	RPMTAG_NOPATCH            = 1052
	RPMTAG_CONFLICTFLAGS      = 1053
	RPMTAG_CONFLICTNAME       = 1054
	RPMTAG_CONFLICTS          = RPMTAG_CONFLICTNAME
	RPMTAG_C                  = RPMTAG_CONFLICTNAME
	RPMTAG_CONFLICTVERSION    = 1055
	RPMTAG_DEFAULTPREFIX      = 1056
	RPMTAG_BUILDROOT          = 1057
	RPMTAG_INSTALLPREFIX      = 1058
	RPMTAG_EXCLUDEARCH        = 1059
	RPMTAG_EXCLUDEOS          = 1060
	RPMTAG_EXCLUSIVEARCH      = 1061
	RPMTAG_EXCLUSIVEOS        = 1062
	RPMTAG_AUTOREQPROV        = 1063
	RPMTAG_RPMVERSION         = 1064
	RPMTAG_TRIGGERSCRIPTS     = 1065
	RPMTAG_TRIGGERNAME        = 1066
	RPMTAG_TRIGGERVERSION     = 1067
	RPMTAG_TRIGGERFLAGS       = 1068
	RPMTAG_TRIGGERINDEX       = 1069
	RPMTAG_VERIFYSCRIPT       = 1079
	RPMTAG_CHANGELOGTIME      = 1080
	RPMTAG_CHANGELOGNAME      = 1081
	RPMTAG_CHANGELOGTEXT      = 1082
	RPMTAG_BROKENMD5          = 1083
	RPMTAG_PREREQ             = 1084
	RPMTAG_PREINPROG          = 1085
	RPMTAG_POSTINPROG         = 1086
	RPMTAG_PREUNPROG          = 1087
	RPMTAG_POSTUNPROG         = 1088
	RPMTAG_BUILDARCHS         = 1089
	RPMTAG_OBSOLETENAME       = 1090
	RPMTAG_OBSOLETES          = RPMTAG_OBSOLETENAME
	RPMTAG_O                  = RPMTAG_OBSOLETENAME
	RPMTAG_VERIFYSCRIPTPROG   = 1091
	RPMTAG_TRIGGERSCRIPTPROG  = 1092
	RPMTAG_DOCDIR             = 1093
	RPMTAG_COOKIE             = 1094
	RPMTAG_FILEDEVICES        = 1095
	RPMTAG_FILEINODES         = 1096
	RPMTAG_FILELANGS          = 1097
	RPMTAG_PREFIXES           = 1098
	RPMTAG_INSTPREFIXES       = 1099
	RPMTAG_TRIGGERIN          = 1100
	RPMTAG_TRIGGERUN          = 1101
	RPMTAG_TRIGGERPOSTUN      = 1102
	RPMTAG_AUTOREQ            = 1103
	RPMTAG_AUTOPROV           = 1104
	RPMTAG_CAPABILITY         = 1105
	RPMTAG_SOURCEPACKAGE      = 1106
	RPMTAG_OLDORIGFILENAMES   = 1107
	RPMTAG_BUILDPREREQ        = 1108
	RPMTAG_BUILDREQUIRES      = 1109
	RPMTAG_BUILDCONFLICTS     = 1110
	RPMTAG_BUILDMACROS        = 1111
	RPMTAG_PROVIDEFLAGS       = 1112
	RPMTAG_PROVIDEVERSION     = 1113
	RPMTAG_OBSOLETEFLAGS      = 1114
	RPMTAG_OBSOLETEVERSION    = 1115
	RPMTAG_DIRINDEXES         = 1116
	RPMTAG_BASENAMES          = 1117
	RPMTAG_DIRNAMES           = 1118
	RPMTAG_ORIGDIRINDEXES     = 1119
	RPMTAG_ORIGBASENAMES      = 1120
	RPMTAG_ORIGDIRNAMES       = 1121
	RPMTAG_OPTFLAGS           = 1122
	RPMTAG_DISTURL            = 1123
	RPMTAG_PAYLOADFORMAT      = 1124
	RPMTAG_PAYLOADCOMPRESSOR  = 1125
	RPMTAG_PAYLOADFLAGS       = 1126
	RPMTAG_INSTALLCOLOR       = 1127
	RPMTAG_INSTALLTID         = 1128
	RPMTAG_REMOVETID          = 1129
	RPMTAG_SHA1RHN            = 1130
	RPMTAG_RHNPLATFORM        = 1131
	RPMTAG_PLATFORM           = 1132
	RPMTAG_PATCHESNAME        = 1133
	RPMTAG_PATCHESFLAGS       = 1134
	RPMTAG_PATCHESVERSION     = 1135
	RPMTAG_CACHECTIME         = 1136
	RPMTAG_CACHEPKGPATH       = 1137
	RPMTAG_CACHEPKGSIZE       = 1138
	RPMTAG_CACHEPKGMTIME      = 1139
	RPMTAG_FILECOLORS         = 1140
	RPMTAG_FILECLASS          = 1141
	RPMTAG_CLASSDICT          = 1142
	RPMTAG_FILEDEPENDSX       = 1143
	RPMTAG_FILEDEPENDSN       = 1144
	RPMTAG_DEPENDSDICT        = 1145
	RPMTAG_SOURCEPKGID        = 1146
	RPMTAG_FILECONTEXTS       = 1147
	RPMTAG_FSCONTEXTS         = 1148
	RPMTAG_RECONTEXTS         = 1149
	RPMTAG_POLICIES           = 1150
	RPMTAG_PRETRANS           = 1151
	RPMTAG_POSTTRANS          = 1152
	RPMTAG_PRETRANSPROG       = 1153
	RPMTAG_POSTTRANSPROG      = 1154
	RPMTAG_DISTTAG            = 1155
	RPMTAG_OLDSUGGESTSNAME    = 1156
	RPMTAG_OLDSUGGESTS        = RPMTAG_OLDSUGGESTSNAME
	RPMTAG_OLDSUGGESTSVERSION = 1157
	RPMTAG_OLDSUGGESTSFLAGS   = 1158
	RPMTAG_OLDENHANCESNAME    = 1159
	RPMTAG_OLDENHANCES        = RPMTAG_OLDENHANCESNAME
	RPMTAG_OLDENHANCESVERSION = 1160
	RPMTAG_OLDENHANCESFLAGS   = 1161
	RPMTAG_PRIORITY           = 1162
	RPMTAG_CVSID              = 1163
	RPMTAG_SVNID              = RPMTAG_CVSID
	RPMTAG_BLINKPKGID         = 1164
	RPMTAG_BLINKHDRID         = 1165
	RPMTAG_BLINKNEVRA         = 1166
	RPMTAG_FLINKPKGID         = 1167
	RPMTAG_FLINKHDRID         = 1168
	RPMTAG_FLINKNEVRA         = 1169
	RPMTAG_PACKAGEORIGIN      = 1170
	RPMTAG_TRIGGERPREIN       = 1171
	RPMTAG_BUILDSUGGESTS      = 1172
	RPMTAG_BUILDENHANCES      = 1173
	RPMTAG_SCRIPTSTATES       = 1174
	RPMTAG_SCRIPTMETRICS      = 1175
	RPMTAG_BUILDCPUCLOCK      = 1176
	RPMTAG_FILEDIGESTALGOS    = 1177
	RPMTAG_VARIANTS           = 1178
	RPMTAG_XMAJOR             = 1179
	RPMTAG_XMINOR             = 1180
	RPMTAG_REPOTAG            = 1181
	RPMTAG_KEYWORDS           = 1182
	RPMTAG_BUILDPLATFORMS     = 1183
	RPMTAG_PACKAGECOLOR       = 1184
	RPMTAG_PACKAGEPREFCOLOR   = 1185
	RPMTAG_XATTRSDICT         = 1186
	RPMTAG_FILEXATTRSX        = 1187
	RPMTAG_DEPATTRSDICT       = 1188
	RPMTAG_CONFLICTATTRSX     = 1189
	RPMTAG_OBSOLETEATTRSX     = 1190
	RPMTAG_PROVIDEATTRSX      = 1191
	RPMTAG_REQUIREATTRSX      = 1192
	RPMTAG_BUILDPROVIDES      = 1193
	RPMTAG_BUILDOBSOLETES     = 1194
	RPMTAG_DBINSTANCE         = 1195
	RPMTAG_NVRA               = 1196

	RPMTAG_FILENAMES                   = 5000
	RPMTAG_FILEPROVIDE                 = 5001
	RPMTAG_FILEREQUIRE                 = 5002
	RPMTAG_FSNAMES                     = 5003
	RPMTAG_FSSIZES                     = 5004
	RPMTAG_TRIGGERCONDS                = 5005
	RPMTAG_TRIGGERTYPE                 = 5006
	RPMTAG_ORIGFILENAMES               = 5007
	RPMTAG_LONGFILESIZES               = 5008
	RPMTAG_LONGSIZE                    = 5009
	RPMTAG_FILECAPS                    = 5010
	RPMTAG_FILEDIGESTALGO              = 5011
	RPMTAG_BUGURL                      = 5012
	RPMTAG_EVR                         = 5013
	RPMTAG_NVR                         = 5014
	RPMTAG_NEVR                        = 5015
	RPMTAG_NEVRA                       = 5016
	RPMTAG_HEADERCOLOR                 = 5017
	RPMTAG_VERBOSE                     = 5018
	RPMTAG_EPOCHNUM                    = 5019
	RPMTAG_PREINFLAGS                  = 5020
	RPMTAG_POSTINFLAGS                 = 5021
	RPMTAG_PREUNFLAGS                  = 5022
	RPMTAG_POSTUNFLAGS                 = 5023
	RPMTAG_PRETRANSFLAGS               = 5024
	RPMTAG_POSTTRANSFLAGS              = 5025
	RPMTAG_VERIFYSCRIPTFLAGS           = 5026
	RPMTAG_TRIGGERSCRIPTFLAGS          = 5027
	RPMTAG_COLLECTIONS                 = 5029
	RPMTAG_POLICYNAMES                 = 5030
	RPMTAG_POLICYTYPES                 = 5031
	RPMTAG_POLICYTYPESINDEXES          = 5032
	RPMTAG_POLICYFLAGS                 = 5033
	RPMTAG_VCS                         = 5034
	RPMTAG_ORDERNAME                   = 5035
	RPMTAG_ORDERVERSION                = 5036
	RPMTAG_ORDERFLAGS                  = 5037
	RPMTAG_MSSFMANIFEST                = 5038
	RPMTAG_MSSFDOMAIN                  = 5039
	RPMTAG_INSTFILENAMES               = 5040
	RPMTAG_REQUIRENEVRS                = 5041
	RPMTAG_PROVIDENEVRS                = 5042
	RPMTAG_OBSOLETENEVRS               = 5043
	RPMTAG_CONFLICTNEVRS               = 5044
	RPMTAG_FILENLINKS                  = 5045
	RPMTAG_RECOMMENDNAME               = 5046
	RPMTAG_RECOMMENDS                  = RPMTAG_RECOMMENDNAME
	RPMTAG_RECOMMENDVERSION            = 5047
	RPMTAG_RECOMMENDFLAGS              = 5048
	RPMTAG_SUGGESTNAME                 = 5049
	RPMTAG_SUGGESTS                    = RPMTAG_SUGGESTNAME
	RPMTAG_SUGGESTVERSION              = 5050
	RPMTAG_SUGGESTFLAGS                = 5051
	RPMTAG_SUPPLEMENTNAME              = 5052
	RPMTAG_SUPPLEMENTS                 = RPMTAG_SUPPLEMENTNAME
	RPMTAG_SUPPLEMENTVERSION           = 5053
	RPMTAG_SUPPLEMENTFLAGS             = 5054
	RPMTAG_ENHANCENAME                 = 5055
	RPMTAG_ENHANCES                    = RPMTAG_ENHANCENAME
	RPMTAG_ENHANCEVERSION              = 5056
	RPMTAG_ENHANCEFLAGS                = 5057
	RPMTAG_RECOMMENDNEVRS              = 5058
	RPMTAG_SUGGESTNEVRS                = 5059
	RPMTAG_SUPPLEMENTNEVRS             = 5060
	RPMTAG_ENHANCENEVRS                = 5061
	RPMTAG_ENCODING                    = 5062
	RPMTAG_FILETRIGGERIN               = 5063
	RPMTAG_FILETRIGGERUN               = 5064
	RPMTAG_FILETRIGGERPOSTUN           = 5065
	RPMTAG_FILETRIGGERSCRIPTS          = 5066
	RPMTAG_FILETRIGGERSCRIPTPROG       = 5067
	RPMTAG_FILETRIGGERSCRIPTFLAGS      = 5068
	RPMTAG_FILETRIGGERNAME             = 5069
	RPMTAG_FILETRIGGERINDEX            = 5070
	RPMTAG_FILETRIGGERVERSION          = 5071
	RPMTAG_FILETRIGGERFLAGS            = 5072
	RPMTAG_TRANSFILETRIGGERIN          = 5073
	RPMTAG_TRANSFILETRIGGERUN          = 5074
	RPMTAG_TRANSFILETRIGGERPOSTUN      = 5075
	RPMTAG_TRANSFILETRIGGERSCRIPTS     = 5076
	RPMTAG_TRANSFILETRIGGERSCRIPTPROG  = 5077
	RPMTAG_TRANSFILETRIGGERSCRIPTFLAGS = 5078
	RPMTAG_TRANSFILETRIGGERNAME        = 5079
	RPMTAG_TRANSFILETRIGGERINDEX       = 5080
	RPMTAG_TRANSFILETRIGGERVERSION     = 5081
	RPMTAG_TRANSFILETRIGGERFLAGS       = 5082
	RPMTAG_REMOVEPATHPOSTFIXES         = 5083
	RPMTAG_FILETRIGGERPRIORITIES       = 5084
	RPMTAG_TRANSFILETRIGGERPRIORITIES  = 5085
	RPMTAG_FILETRIGGERCONDS            = 5086
	RPMTAG_FILETRIGGERTYPE             = 5087
	RPMTAG_TRANSFILETRIGGERCONDS       = 5088
	RPMTAG_TRANSFILETRIGGERTYPE        = 5089
	RPMTAG_FILESIGNATURES              = 5090
	RPMTAG_FILESIGNATURELENGTH         = 5091
)
