// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1/generated.proto

/*
	Package v1beta1 is a generated protocol buffer package.

	It is generated from these files:
		k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1/generated.proto

	It has these top-level messages:
		CustomResourceDefinition
		CustomResourceDefinitionCondition
		CustomResourceDefinitionList
		CustomResourceDefinitionNames
		CustomResourceDefinitionSpec
		CustomResourceDefinitionStatus
		CustomResourceValidation
		ExternalDocumentation
		JSON
		JSONSchemaProps
		JSONSchemaPropsOrArray
		JSONSchemaPropsOrBool
		JSONSchemaPropsOrStringArray
*/
package v1beta1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import k8s_io_apimachinery_pkg_apis_meta_v1 "github.com/ericchiang/k8s/apis/meta/v1"
import _ "github.com/ericchiang/k8s/runtime"
import _ "github.com/ericchiang/k8s/runtime/schema"
import _ "github.com/ericchiang/k8s/util/intstr"

import encoding_binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format
// <.spec.name>.<.spec.group>.
type CustomResourceDefinition struct {
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec describes how the user wants the resources to appear
	Spec *CustomResourceDefinitionSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status indicates the actual state of the CustomResourceDefinition
	Status           *CustomResourceDefinitionStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte                          `json:"-"`
}

func (m *CustomResourceDefinition) Reset()         { *m = CustomResourceDefinition{} }
func (m *CustomResourceDefinition) String() string { return proto.CompactTextString(m) }
func (*CustomResourceDefinition) ProtoMessage()    {}
func (*CustomResourceDefinition) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{0}
}

func (m *CustomResourceDefinition) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *CustomResourceDefinition) GetSpec() *CustomResourceDefinitionSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *CustomResourceDefinition) GetStatus() *CustomResourceDefinitionStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// CustomResourceDefinitionCondition contains details for the current condition of this pod.
type CustomResourceDefinitionCondition struct {
	// Type is the type of the condition.
	Type *string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Status is the status of the condition.
	// Can be True, False, Unknown.
	Status *string `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
	// Last time the condition transitioned from one status to another.
	// +optional
	LastTransitionTime *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,3,opt,name=lastTransitionTime" json:"lastTransitionTime,omitempty"`
	// Unique, one-word, CamelCase reason for the condition's last transition.
	// +optional
	Reason *string `protobuf:"bytes,4,opt,name=reason" json:"reason,omitempty"`
	// Human-readable message indicating details about last transition.
	// +optional
	Message          *string `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CustomResourceDefinitionCondition) Reset()         { *m = CustomResourceDefinitionCondition{} }
func (m *CustomResourceDefinitionCondition) String() string { return proto.CompactTextString(m) }
func (*CustomResourceDefinitionCondition) ProtoMessage()    {}
func (*CustomResourceDefinitionCondition) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{1}
}

func (m *CustomResourceDefinitionCondition) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *CustomResourceDefinitionCondition) GetStatus() string {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return ""
}

func (m *CustomResourceDefinitionCondition) GetLastTransitionTime() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

func (m *CustomResourceDefinitionCondition) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *CustomResourceDefinitionCondition) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
type CustomResourceDefinitionList struct {
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items individual CustomResourceDefinitions
	Items            []*CustomResourceDefinition `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte                      `json:"-"`
}

func (m *CustomResourceDefinitionList) Reset()         { *m = CustomResourceDefinitionList{} }
func (m *CustomResourceDefinitionList) String() string { return proto.CompactTextString(m) }
func (*CustomResourceDefinitionList) ProtoMessage()    {}
func (*CustomResourceDefinitionList) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{2}
}

func (m *CustomResourceDefinitionList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *CustomResourceDefinitionList) GetItems() []*CustomResourceDefinition {
	if m != nil {
		return m.Items
	}
	return nil
}

// CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
type CustomResourceDefinitionNames struct {
	// Plural is the plural name of the resource to serve.  It must match the name of the CustomResourceDefinition-registration
	// too: plural.group and it must be all lowercase.
	Plural *string `protobuf:"bytes,1,opt,name=plural" json:"plural,omitempty"`
	// Singular is the singular name of the resource.  It must be all lowercase  Defaults to lowercased <kind>
	Singular *string `protobuf:"bytes,2,opt,name=singular" json:"singular,omitempty"`
	// ShortNames are short names for the resource.  It must be all lowercase.
	ShortNames []string `protobuf:"bytes,3,rep,name=shortNames" json:"shortNames,omitempty"`
	// Kind is the serialized kind of the resource.  It is normally CamelCase and singular.
	Kind *string `protobuf:"bytes,4,opt,name=kind" json:"kind,omitempty"`
	// ListKind is the serialized kind of the list for this resource.  Defaults to <kind>List.
	ListKind         *string `protobuf:"bytes,5,opt,name=listKind" json:"listKind,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CustomResourceDefinitionNames) Reset()         { *m = CustomResourceDefinitionNames{} }
func (m *CustomResourceDefinitionNames) String() string { return proto.CompactTextString(m) }
func (*CustomResourceDefinitionNames) ProtoMessage()    {}
func (*CustomResourceDefinitionNames) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{3}
}

func (m *CustomResourceDefinitionNames) GetPlural() string {
	if m != nil && m.Plural != nil {
		return *m.Plural
	}
	return ""
}

func (m *CustomResourceDefinitionNames) GetSingular() string {
	if m != nil && m.Singular != nil {
		return *m.Singular
	}
	return ""
}

func (m *CustomResourceDefinitionNames) GetShortNames() []string {
	if m != nil {
		return m.ShortNames
	}
	return nil
}

func (m *CustomResourceDefinitionNames) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *CustomResourceDefinitionNames) GetListKind() string {
	if m != nil && m.ListKind != nil {
		return *m.ListKind
	}
	return ""
}

// CustomResourceDefinitionSpec describes how a user wants their resource to appear
type CustomResourceDefinitionSpec struct {
	// Group is the group this resource belongs in
	Group *string `protobuf:"bytes,1,opt,name=group" json:"group,omitempty"`
	// Version is the version this resource belongs in
	Version *string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	// Names are the names used to describe this custom resource
	Names *CustomResourceDefinitionNames `protobuf:"bytes,3,opt,name=names" json:"names,omitempty"`
	// Scope indicates whether this resource is cluster or namespace scoped.  Default is namespaced
	Scope *string `protobuf:"bytes,4,opt,name=scope" json:"scope,omitempty"`
	// Validation describes the validation methods for CustomResources
	// +optional
	Validation       *CustomResourceValidation `protobuf:"bytes,5,opt,name=validation" json:"validation,omitempty"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *CustomResourceDefinitionSpec) Reset()         { *m = CustomResourceDefinitionSpec{} }
func (m *CustomResourceDefinitionSpec) String() string { return proto.CompactTextString(m) }
func (*CustomResourceDefinitionSpec) ProtoMessage()    {}
func (*CustomResourceDefinitionSpec) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{4}
}

func (m *CustomResourceDefinitionSpec) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

func (m *CustomResourceDefinitionSpec) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *CustomResourceDefinitionSpec) GetNames() *CustomResourceDefinitionNames {
	if m != nil {
		return m.Names
	}
	return nil
}

func (m *CustomResourceDefinitionSpec) GetScope() string {
	if m != nil && m.Scope != nil {
		return *m.Scope
	}
	return ""
}

func (m *CustomResourceDefinitionSpec) GetValidation() *CustomResourceValidation {
	if m != nil {
		return m.Validation
	}
	return nil
}

// CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
type CustomResourceDefinitionStatus struct {
	// Conditions indicate state for particular aspects of a CustomResourceDefinition
	Conditions []*CustomResourceDefinitionCondition `protobuf:"bytes,1,rep,name=conditions" json:"conditions,omitempty"`
	// AcceptedNames are the names that are actually being used to serve discovery
	// They may be different than the names in spec.
	AcceptedNames    *CustomResourceDefinitionNames `protobuf:"bytes,2,opt,name=acceptedNames" json:"acceptedNames,omitempty"`
	XXX_unrecognized []byte                         `json:"-"`
}

func (m *CustomResourceDefinitionStatus) Reset()         { *m = CustomResourceDefinitionStatus{} }
func (m *CustomResourceDefinitionStatus) String() string { return proto.CompactTextString(m) }
func (*CustomResourceDefinitionStatus) ProtoMessage()    {}
func (*CustomResourceDefinitionStatus) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{5}
}

func (m *CustomResourceDefinitionStatus) GetConditions() []*CustomResourceDefinitionCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *CustomResourceDefinitionStatus) GetAcceptedNames() *CustomResourceDefinitionNames {
	if m != nil {
		return m.AcceptedNames
	}
	return nil
}

// CustomResourceValidation is a list of validation methods for CustomResources.
type CustomResourceValidation struct {
	// OpenAPIV3Schema is the OpenAPI v3 schema to be validated against.
	OpenAPIV3Schema  *JSONSchemaProps `protobuf:"bytes,1,opt,name=openAPIV3Schema" json:"openAPIV3Schema,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *CustomResourceValidation) Reset()         { *m = CustomResourceValidation{} }
func (m *CustomResourceValidation) String() string { return proto.CompactTextString(m) }
func (*CustomResourceValidation) ProtoMessage()    {}
func (*CustomResourceValidation) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{6}
}

func (m *CustomResourceValidation) GetOpenAPIV3Schema() *JSONSchemaProps {
	if m != nil {
		return m.OpenAPIV3Schema
	}
	return nil
}

// ExternalDocumentation allows referencing an external resource for extended documentation.
type ExternalDocumentation struct {
	Description      *string `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	Url              *string `protobuf:"bytes,2,opt,name=url" json:"url,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExternalDocumentation) Reset()                    { *m = ExternalDocumentation{} }
func (m *ExternalDocumentation) String() string            { return proto.CompactTextString(m) }
func (*ExternalDocumentation) ProtoMessage()               {}
func (*ExternalDocumentation) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{7} }

func (m *ExternalDocumentation) GetDescription() string {
	if m != nil && m.Description != nil {
		return *m.Description
	}
	return ""
}

func (m *ExternalDocumentation) GetUrl() string {
	if m != nil && m.Url != nil {
		return *m.Url
	}
	return ""
}

// JSON represents any valid JSON value.
// These types are supported: bool, int64, float64, string, []interface{}, map[string]interface{} and nil.
type JSON struct {
	Raw              []byte `protobuf:"bytes,1,opt,name=raw" json:"raw,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *JSON) Reset()                    { *m = JSON{} }
func (m *JSON) String() string            { return proto.CompactTextString(m) }
func (*JSON) ProtoMessage()               {}
func (*JSON) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{8} }

func (m *JSON) GetRaw() []byte {
	if m != nil {
		return m.Raw
	}
	return nil
}

// JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
type JSONSchemaProps struct {
	Id                   *string                                  `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Schema               *string                                  `protobuf:"bytes,2,opt,name=schema" json:"schema,omitempty"`
	Ref                  *string                                  `protobuf:"bytes,3,opt,name=ref" json:"ref,omitempty"`
	Description          *string                                  `protobuf:"bytes,4,opt,name=description" json:"description,omitempty"`
	Type                 *string                                  `protobuf:"bytes,5,opt,name=type" json:"type,omitempty"`
	Format               *string                                  `protobuf:"bytes,6,opt,name=format" json:"format,omitempty"`
	Title                *string                                  `protobuf:"bytes,7,opt,name=title" json:"title,omitempty"`
	Default              *JSON                                    `protobuf:"bytes,8,opt,name=default" json:"default,omitempty"`
	Maximum              *float64                                 `protobuf:"fixed64,9,opt,name=maximum" json:"maximum,omitempty"`
	ExclusiveMaximum     *bool                                    `protobuf:"varint,10,opt,name=exclusiveMaximum" json:"exclusiveMaximum,omitempty"`
	Minimum              *float64                                 `protobuf:"fixed64,11,opt,name=minimum" json:"minimum,omitempty"`
	ExclusiveMinimum     *bool                                    `protobuf:"varint,12,opt,name=exclusiveMinimum" json:"exclusiveMinimum,omitempty"`
	MaxLength            *int64                                   `protobuf:"varint,13,opt,name=maxLength" json:"maxLength,omitempty"`
	MinLength            *int64                                   `protobuf:"varint,14,opt,name=minLength" json:"minLength,omitempty"`
	Pattern              *string                                  `protobuf:"bytes,15,opt,name=pattern" json:"pattern,omitempty"`
	MaxItems             *int64                                   `protobuf:"varint,16,opt,name=maxItems" json:"maxItems,omitempty"`
	MinItems             *int64                                   `protobuf:"varint,17,opt,name=minItems" json:"minItems,omitempty"`
	UniqueItems          *bool                                    `protobuf:"varint,18,opt,name=uniqueItems" json:"uniqueItems,omitempty"`
	MultipleOf           *float64                                 `protobuf:"fixed64,19,opt,name=multipleOf" json:"multipleOf,omitempty"`
	Enum                 []*JSON                                  `protobuf:"bytes,20,rep,name=enum" json:"enum,omitempty"`
	MaxProperties        *int64                                   `protobuf:"varint,21,opt,name=maxProperties" json:"maxProperties,omitempty"`
	MinProperties        *int64                                   `protobuf:"varint,22,opt,name=minProperties" json:"minProperties,omitempty"`
	Required             []string                                 `protobuf:"bytes,23,rep,name=required" json:"required,omitempty"`
	Items                *JSONSchemaPropsOrArray                  `protobuf:"bytes,24,opt,name=items" json:"items,omitempty"`
	AllOf                []*JSONSchemaProps                       `protobuf:"bytes,25,rep,name=allOf" json:"allOf,omitempty"`
	OneOf                []*JSONSchemaProps                       `protobuf:"bytes,26,rep,name=oneOf" json:"oneOf,omitempty"`
	AnyOf                []*JSONSchemaProps                       `protobuf:"bytes,27,rep,name=anyOf" json:"anyOf,omitempty"`
	Not                  *JSONSchemaProps                         `protobuf:"bytes,28,opt,name=not" json:"not,omitempty"`
	Properties           map[string]*JSONSchemaProps              `protobuf:"bytes,29,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	AdditionalProperties *JSONSchemaPropsOrBool                   `protobuf:"bytes,30,opt,name=additionalProperties" json:"additionalProperties,omitempty"`
	PatternProperties    map[string]*JSONSchemaProps              `protobuf:"bytes,31,rep,name=patternProperties" json:"patternProperties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Dependencies         map[string]*JSONSchemaPropsOrStringArray `protobuf:"bytes,32,rep,name=dependencies" json:"dependencies,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	AdditionalItems      *JSONSchemaPropsOrBool                   `protobuf:"bytes,33,opt,name=additionalItems" json:"additionalItems,omitempty"`
	Definitions          map[string]*JSONSchemaProps              `protobuf:"bytes,34,rep,name=definitions" json:"definitions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ExternalDocs         *ExternalDocumentation                   `protobuf:"bytes,35,opt,name=externalDocs" json:"externalDocs,omitempty"`
	Example              *JSON                                    `protobuf:"bytes,36,opt,name=example" json:"example,omitempty"`
	XXX_unrecognized     []byte                                   `json:"-"`
}

func (m *JSONSchemaProps) Reset()                    { *m = JSONSchemaProps{} }
func (m *JSONSchemaProps) String() string            { return proto.CompactTextString(m) }
func (*JSONSchemaProps) ProtoMessage()               {}
func (*JSONSchemaProps) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{9} }

func (m *JSONSchemaProps) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *JSONSchemaProps) GetSchema() string {
	if m != nil && m.Schema != nil {
		return *m.Schema
	}
	return ""
}

func (m *JSONSchemaProps) GetRef() string {
	if m != nil && m.Ref != nil {
		return *m.Ref
	}
	return ""
}

func (m *JSONSchemaProps) GetDescription() string {
	if m != nil && m.Description != nil {
		return *m.Description
	}
	return ""
}

func (m *JSONSchemaProps) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *JSONSchemaProps) GetFormat() string {
	if m != nil && m.Format != nil {
		return *m.Format
	}
	return ""
}

func (m *JSONSchemaProps) GetTitle() string {
	if m != nil && m.Title != nil {
		return *m.Title
	}
	return ""
}

func (m *JSONSchemaProps) GetDefault() *JSON {
	if m != nil {
		return m.Default
	}
	return nil
}

func (m *JSONSchemaProps) GetMaximum() float64 {
	if m != nil && m.Maximum != nil {
		return *m.Maximum
	}
	return 0
}

func (m *JSONSchemaProps) GetExclusiveMaximum() bool {
	if m != nil && m.ExclusiveMaximum != nil {
		return *m.ExclusiveMaximum
	}
	return false
}

func (m *JSONSchemaProps) GetMinimum() float64 {
	if m != nil && m.Minimum != nil {
		return *m.Minimum
	}
	return 0
}

func (m *JSONSchemaProps) GetExclusiveMinimum() bool {
	if m != nil && m.ExclusiveMinimum != nil {
		return *m.ExclusiveMinimum
	}
	return false
}

func (m *JSONSchemaProps) GetMaxLength() int64 {
	if m != nil && m.MaxLength != nil {
		return *m.MaxLength
	}
	return 0
}

func (m *JSONSchemaProps) GetMinLength() int64 {
	if m != nil && m.MinLength != nil {
		return *m.MinLength
	}
	return 0
}

func (m *JSONSchemaProps) GetPattern() string {
	if m != nil && m.Pattern != nil {
		return *m.Pattern
	}
	return ""
}

func (m *JSONSchemaProps) GetMaxItems() int64 {
	if m != nil && m.MaxItems != nil {
		return *m.MaxItems
	}
	return 0
}

func (m *JSONSchemaProps) GetMinItems() int64 {
	if m != nil && m.MinItems != nil {
		return *m.MinItems
	}
	return 0
}

func (m *JSONSchemaProps) GetUniqueItems() bool {
	if m != nil && m.UniqueItems != nil {
		return *m.UniqueItems
	}
	return false
}

func (m *JSONSchemaProps) GetMultipleOf() float64 {
	if m != nil && m.MultipleOf != nil {
		return *m.MultipleOf
	}
	return 0
}

func (m *JSONSchemaProps) GetEnum() []*JSON {
	if m != nil {
		return m.Enum
	}
	return nil
}

func (m *JSONSchemaProps) GetMaxProperties() int64 {
	if m != nil && m.MaxProperties != nil {
		return *m.MaxProperties
	}
	return 0
}

func (m *JSONSchemaProps) GetMinProperties() int64 {
	if m != nil && m.MinProperties != nil {
		return *m.MinProperties
	}
	return 0
}

func (m *JSONSchemaProps) GetRequired() []string {
	if m != nil {
		return m.Required
	}
	return nil
}

func (m *JSONSchemaProps) GetItems() *JSONSchemaPropsOrArray {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *JSONSchemaProps) GetAllOf() []*JSONSchemaProps {
	if m != nil {
		return m.AllOf
	}
	return nil
}

func (m *JSONSchemaProps) GetOneOf() []*JSONSchemaProps {
	if m != nil {
		return m.OneOf
	}
	return nil
}

func (m *JSONSchemaProps) GetAnyOf() []*JSONSchemaProps {
	if m != nil {
		return m.AnyOf
	}
	return nil
}

func (m *JSONSchemaProps) GetNot() *JSONSchemaProps {
	if m != nil {
		return m.Not
	}
	return nil
}

func (m *JSONSchemaProps) GetProperties() map[string]*JSONSchemaProps {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *JSONSchemaProps) GetAdditionalProperties() *JSONSchemaPropsOrBool {
	if m != nil {
		return m.AdditionalProperties
	}
	return nil
}

func (m *JSONSchemaProps) GetPatternProperties() map[string]*JSONSchemaProps {
	if m != nil {
		return m.PatternProperties
	}
	return nil
}

func (m *JSONSchemaProps) GetDependencies() map[string]*JSONSchemaPropsOrStringArray {
	if m != nil {
		return m.Dependencies
	}
	return nil
}

func (m *JSONSchemaProps) GetAdditionalItems() *JSONSchemaPropsOrBool {
	if m != nil {
		return m.AdditionalItems
	}
	return nil
}

func (m *JSONSchemaProps) GetDefinitions() map[string]*JSONSchemaProps {
	if m != nil {
		return m.Definitions
	}
	return nil
}

func (m *JSONSchemaProps) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

func (m *JSONSchemaProps) GetExample() *JSON {
	if m != nil {
		return m.Example
	}
	return nil
}

// JSONSchemaPropsOrArray represents a value that can either be a JSONSchemaProps
// or an array of JSONSchemaProps. Mainly here for serialization purposes.
type JSONSchemaPropsOrArray struct {
	Schema           *JSONSchemaProps   `protobuf:"bytes,1,opt,name=schema" json:"schema,omitempty"`
	JSONSchemas      []*JSONSchemaProps `protobuf:"bytes,2,rep,name=jSONSchemas" json:"jSONSchemas,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *JSONSchemaPropsOrArray) Reset()                    { *m = JSONSchemaPropsOrArray{} }
func (m *JSONSchemaPropsOrArray) String() string            { return proto.CompactTextString(m) }
func (*JSONSchemaPropsOrArray) ProtoMessage()               {}
func (*JSONSchemaPropsOrArray) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{10} }

func (m *JSONSchemaPropsOrArray) GetSchema() *JSONSchemaProps {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *JSONSchemaPropsOrArray) GetJSONSchemas() []*JSONSchemaProps {
	if m != nil {
		return m.JSONSchemas
	}
	return nil
}

// JSONSchemaPropsOrBool represents JSONSchemaProps or a boolean value.
// Defaults to true for the boolean property.
type JSONSchemaPropsOrBool struct {
	Allows           *bool            `protobuf:"varint,1,opt,name=allows" json:"allows,omitempty"`
	Schema           *JSONSchemaProps `protobuf:"bytes,2,opt,name=schema" json:"schema,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *JSONSchemaPropsOrBool) Reset()                    { *m = JSONSchemaPropsOrBool{} }
func (m *JSONSchemaPropsOrBool) String() string            { return proto.CompactTextString(m) }
func (*JSONSchemaPropsOrBool) ProtoMessage()               {}
func (*JSONSchemaPropsOrBool) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{11} }

func (m *JSONSchemaPropsOrBool) GetAllows() bool {
	if m != nil && m.Allows != nil {
		return *m.Allows
	}
	return false
}

func (m *JSONSchemaPropsOrBool) GetSchema() *JSONSchemaProps {
	if m != nil {
		return m.Schema
	}
	return nil
}

// JSONSchemaPropsOrStringArray represents a JSONSchemaProps or a string array.
type JSONSchemaPropsOrStringArray struct {
	Schema           *JSONSchemaProps `protobuf:"bytes,1,opt,name=schema" json:"schema,omitempty"`
	Property         []string         `protobuf:"bytes,2,rep,name=property" json:"property,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *JSONSchemaPropsOrStringArray) Reset()         { *m = JSONSchemaPropsOrStringArray{} }
func (m *JSONSchemaPropsOrStringArray) String() string { return proto.CompactTextString(m) }
func (*JSONSchemaPropsOrStringArray) ProtoMessage()    {}
func (*JSONSchemaPropsOrStringArray) Descriptor() ([]byte, []int) {
	return fileDescriptorGenerated, []int{12}
}

func (m *JSONSchemaPropsOrStringArray) GetSchema() *JSONSchemaProps {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *JSONSchemaPropsOrStringArray) GetProperty() []string {
	if m != nil {
		return m.Property
	}
	return nil
}

func init() {
	proto.RegisterType((*CustomResourceDefinition)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition")
	proto.RegisterType((*CustomResourceDefinitionCondition)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionCondition")
	proto.RegisterType((*CustomResourceDefinitionList)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList")
	proto.RegisterType((*CustomResourceDefinitionNames)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames")
	proto.RegisterType((*CustomResourceDefinitionSpec)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec")
	proto.RegisterType((*CustomResourceDefinitionStatus)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionStatus")
	proto.RegisterType((*CustomResourceValidation)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceValidation")
	proto.RegisterType((*ExternalDocumentation)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.ExternalDocumentation")
	proto.RegisterType((*JSON)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.JSON")
	proto.RegisterType((*JSONSchemaProps)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps")
	proto.RegisterType((*JSONSchemaPropsOrArray)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaPropsOrArray")
	proto.RegisterType((*JSONSchemaPropsOrBool)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaPropsOrBool")
	proto.RegisterType((*JSONSchemaPropsOrStringArray)(nil), "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaPropsOrStringArray")
}
func (m *CustomResourceDefinition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CustomResourceDefinition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n1, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Spec != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Spec.Size()))
		n2, err := m.Spec.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Status != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Status.Size()))
		n3, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CustomResourceDefinitionCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CustomResourceDefinitionCondition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.Status != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Status)))
		i += copy(dAtA[i:], *m.Status)
	}
	if m.LastTransitionTime != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastTransitionTime.Size()))
		n4, err := m.LastTransitionTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Reason != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Message != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CustomResourceDefinitionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CustomResourceDefinitionList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n5, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CustomResourceDefinitionNames) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CustomResourceDefinitionNames) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Plural != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Plural)))
		i += copy(dAtA[i:], *m.Plural)
	}
	if m.Singular != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Singular)))
		i += copy(dAtA[i:], *m.Singular)
	}
	if len(m.ShortNames) > 0 {
		for _, s := range m.ShortNames {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Kind != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Kind)))
		i += copy(dAtA[i:], *m.Kind)
	}
	if m.ListKind != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ListKind)))
		i += copy(dAtA[i:], *m.ListKind)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CustomResourceDefinitionSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CustomResourceDefinitionSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Group != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Group)))
		i += copy(dAtA[i:], *m.Group)
	}
	if m.Version != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Version)))
		i += copy(dAtA[i:], *m.Version)
	}
	if m.Names != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Names.Size()))
		n6, err := m.Names.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Scope != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Scope)))
		i += copy(dAtA[i:], *m.Scope)
	}
	if m.Validation != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Validation.Size()))
		n7, err := m.Validation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CustomResourceDefinitionStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CustomResourceDefinitionStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for _, msg := range m.Conditions {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AcceptedNames != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.AcceptedNames.Size()))
		n8, err := m.AcceptedNames.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CustomResourceValidation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CustomResourceValidation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.OpenAPIV3Schema != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.OpenAPIV3Schema.Size()))
		n9, err := m.OpenAPIV3Schema.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalDocumentation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalDocumentation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Description != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Description)))
		i += copy(dAtA[i:], *m.Description)
	}
	if m.Url != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Url)))
		i += copy(dAtA[i:], *m.Url)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *JSON) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JSON) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Raw != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(m.Raw)))
		i += copy(dAtA[i:], m.Raw)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *JSONSchemaProps) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JSONSchemaProps) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Id)))
		i += copy(dAtA[i:], *m.Id)
	}
	if m.Schema != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Schema)))
		i += copy(dAtA[i:], *m.Schema)
	}
	if m.Ref != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Ref)))
		i += copy(dAtA[i:], *m.Ref)
	}
	if m.Description != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Description)))
		i += copy(dAtA[i:], *m.Description)
	}
	if m.Type != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.Format != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Format)))
		i += copy(dAtA[i:], *m.Format)
	}
	if m.Title != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Title)))
		i += copy(dAtA[i:], *m.Title)
	}
	if m.Default != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Default.Size()))
		n10, err := m.Default.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Maximum != nil {
		dAtA[i] = 0x49
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.Maximum))))
		i += 8
	}
	if m.ExclusiveMaximum != nil {
		dAtA[i] = 0x50
		i++
		if *m.ExclusiveMaximum {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Minimum != nil {
		dAtA[i] = 0x59
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.Minimum))))
		i += 8
	}
	if m.ExclusiveMinimum != nil {
		dAtA[i] = 0x60
		i++
		if *m.ExclusiveMinimum {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MaxLength != nil {
		dAtA[i] = 0x68
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.MaxLength))
	}
	if m.MinLength != nil {
		dAtA[i] = 0x70
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.MinLength))
	}
	if m.Pattern != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Pattern)))
		i += copy(dAtA[i:], *m.Pattern)
	}
	if m.MaxItems != nil {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.MaxItems))
	}
	if m.MinItems != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.MinItems))
	}
	if m.UniqueItems != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		if *m.UniqueItems {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MultipleOf != nil {
		dAtA[i] = 0x99
		i++
		dAtA[i] = 0x1
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.MultipleOf))))
		i += 8
	}
	if len(m.Enum) > 0 {
		for _, msg := range m.Enum {
			dAtA[i] = 0xa2
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MaxProperties != nil {
		dAtA[i] = 0xa8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.MaxProperties))
	}
	if m.MinProperties != nil {
		dAtA[i] = 0xb0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.MinProperties))
	}
	if len(m.Required) > 0 {
		for _, s := range m.Required {
			dAtA[i] = 0xba
			i++
			dAtA[i] = 0x1
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Items != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Items.Size()))
		n11, err := m.Items.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if len(m.AllOf) > 0 {
		for _, msg := range m.AllOf {
			dAtA[i] = 0xca
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OneOf) > 0 {
		for _, msg := range m.OneOf {
			dAtA[i] = 0xd2
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.AnyOf) > 0 {
		for _, msg := range m.AnyOf {
			dAtA[i] = 0xda
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Not != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Not.Size()))
		n12, err := m.Not.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if len(m.Properties) > 0 {
		for k, _ := range m.Properties {
			dAtA[i] = 0xea
			i++
			dAtA[i] = 0x1
			i++
			v := m.Properties[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n13, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n13
			}
		}
	}
	if m.AdditionalProperties != nil {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.AdditionalProperties.Size()))
		n14, err := m.AdditionalProperties.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if len(m.PatternProperties) > 0 {
		for k, _ := range m.PatternProperties {
			dAtA[i] = 0xfa
			i++
			dAtA[i] = 0x1
			i++
			v := m.PatternProperties[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n15, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n15
			}
		}
	}
	if len(m.Dependencies) > 0 {
		for k, _ := range m.Dependencies {
			dAtA[i] = 0x82
			i++
			dAtA[i] = 0x2
			i++
			v := m.Dependencies[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n16, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n16
			}
		}
	}
	if m.AdditionalItems != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.AdditionalItems.Size()))
		n17, err := m.AdditionalItems.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if len(m.Definitions) > 0 {
		for k, _ := range m.Definitions {
			dAtA[i] = 0x92
			i++
			dAtA[i] = 0x2
			i++
			v := m.Definitions[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGenerated(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGenerated(uint64(len(k))) + msgSize
			i = encodeVarintGenerated(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGenerated(dAtA, i, uint64(v.Size()))
				n18, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n18
			}
		}
	}
	if m.ExternalDocs != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.ExternalDocs.Size()))
		n19, err := m.ExternalDocs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.Example != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Example.Size()))
		n20, err := m.Example.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *JSONSchemaPropsOrArray) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JSONSchemaPropsOrArray) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Schema != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Schema.Size()))
		n21, err := m.Schema.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if len(m.JSONSchemas) > 0 {
		for _, msg := range m.JSONSchemas {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *JSONSchemaPropsOrBool) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JSONSchemaPropsOrBool) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Allows != nil {
		dAtA[i] = 0x8
		i++
		if *m.Allows {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Schema != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Schema.Size()))
		n22, err := m.Schema.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *JSONSchemaPropsOrStringArray) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JSONSchemaPropsOrStringArray) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Schema != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Schema.Size()))
		n23, err := m.Schema.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if len(m.Property) > 0 {
		for _, s := range m.Property {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *CustomResourceDefinition) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CustomResourceDefinitionCondition) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Status != nil {
		l = len(*m.Status)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.LastTransitionTime != nil {
		l = m.LastTransitionTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CustomResourceDefinitionList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CustomResourceDefinitionNames) Size() (n int) {
	var l int
	_ = l
	if m.Plural != nil {
		l = len(*m.Plural)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Singular != nil {
		l = len(*m.Singular)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.ShortNames) > 0 {
		for _, s := range m.ShortNames {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ListKind != nil {
		l = len(*m.ListKind)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CustomResourceDefinitionSpec) Size() (n int) {
	var l int
	_ = l
	if m.Group != nil {
		l = len(*m.Group)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Version != nil {
		l = len(*m.Version)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Names != nil {
		l = m.Names.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Scope != nil {
		l = len(*m.Scope)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Validation != nil {
		l = m.Validation.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CustomResourceDefinitionStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.AcceptedNames != nil {
		l = m.AcceptedNames.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CustomResourceValidation) Size() (n int) {
	var l int
	_ = l
	if m.OpenAPIV3Schema != nil {
		l = m.OpenAPIV3Schema.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalDocumentation) Size() (n int) {
	var l int
	_ = l
	if m.Description != nil {
		l = len(*m.Description)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Url != nil {
		l = len(*m.Url)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *JSON) Size() (n int) {
	var l int
	_ = l
	if m.Raw != nil {
		l = len(m.Raw)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *JSONSchemaProps) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		l = len(*m.Id)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Schema != nil {
		l = len(*m.Schema)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Ref != nil {
		l = len(*m.Ref)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Description != nil {
		l = len(*m.Description)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Format != nil {
		l = len(*m.Format)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Title != nil {
		l = len(*m.Title)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Default != nil {
		l = m.Default.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Maximum != nil {
		n += 9
	}
	if m.ExclusiveMaximum != nil {
		n += 2
	}
	if m.Minimum != nil {
		n += 9
	}
	if m.ExclusiveMinimum != nil {
		n += 2
	}
	if m.MaxLength != nil {
		n += 1 + sovGenerated(uint64(*m.MaxLength))
	}
	if m.MinLength != nil {
		n += 1 + sovGenerated(uint64(*m.MinLength))
	}
	if m.Pattern != nil {
		l = len(*m.Pattern)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.MaxItems != nil {
		n += 2 + sovGenerated(uint64(*m.MaxItems))
	}
	if m.MinItems != nil {
		n += 2 + sovGenerated(uint64(*m.MinItems))
	}
	if m.UniqueItems != nil {
		n += 3
	}
	if m.MultipleOf != nil {
		n += 10
	}
	if len(m.Enum) > 0 {
		for _, e := range m.Enum {
			l = e.Size()
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if m.MaxProperties != nil {
		n += 2 + sovGenerated(uint64(*m.MaxProperties))
	}
	if m.MinProperties != nil {
		n += 2 + sovGenerated(uint64(*m.MinProperties))
	}
	if len(m.Required) > 0 {
		for _, s := range m.Required {
			l = len(s)
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if m.Items != nil {
		l = m.Items.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if len(m.AllOf) > 0 {
		for _, e := range m.AllOf {
			l = e.Size()
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.OneOf) > 0 {
		for _, e := range m.OneOf {
			l = e.Size()
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.AnyOf) > 0 {
		for _, e := range m.AnyOf {
			l = e.Size()
			n += 2 + l + sovGenerated(uint64(l))
		}
	}
	if m.Not != nil {
		l = m.Not.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if len(m.Properties) > 0 {
		for k, v := range m.Properties {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.AdditionalProperties != nil {
		l = m.AdditionalProperties.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if len(m.PatternProperties) > 0 {
		for k, v := range m.PatternProperties {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.Dependencies) > 0 {
		for k, v := range m.Dependencies {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.AdditionalItems != nil {
		l = m.AdditionalItems.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if len(m.Definitions) > 0 {
		for k, v := range m.Definitions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGenerated(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if m.ExternalDocs != nil {
		l = m.ExternalDocs.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.Example != nil {
		l = m.Example.Size()
		n += 2 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *JSONSchemaPropsOrArray) Size() (n int) {
	var l int
	_ = l
	if m.Schema != nil {
		l = m.Schema.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.JSONSchemas) > 0 {
		for _, e := range m.JSONSchemas {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *JSONSchemaPropsOrBool) Size() (n int) {
	var l int
	_ = l
	if m.Allows != nil {
		n += 2
	}
	if m.Schema != nil {
		l = m.Schema.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *JSONSchemaPropsOrStringArray) Size() (n int) {
	var l int
	_ = l
	if m.Schema != nil {
		l = m.Schema.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Property) > 0 {
		for _, s := range m.Property {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovGenerated(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CustomResourceDefinition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomResourceDefinition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomResourceDefinition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &CustomResourceDefinitionSpec{}
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &CustomResourceDefinitionStatus{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CustomResourceDefinitionCondition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomResourceDefinitionCondition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomResourceDefinitionCondition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Type = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Status = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastTransitionTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastTransitionTime == nil {
				m.LastTransitionTime = &k8s_io_apimachinery_pkg_apis_meta_v1.Time{}
			}
			if err := m.LastTransitionTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Reason = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CustomResourceDefinitionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomResourceDefinitionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomResourceDefinitionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &CustomResourceDefinition{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CustomResourceDefinitionNames) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomResourceDefinitionNames: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomResourceDefinitionNames: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Plural", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Plural = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Singular", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Singular = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShortNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShortNames = append(m.ShortNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Kind = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ListKind = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CustomResourceDefinitionSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomResourceDefinitionSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomResourceDefinitionSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Group = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Version = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Names == nil {
				m.Names = &CustomResourceDefinitionNames{}
			}
			if err := m.Names.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Scope = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Validation == nil {
				m.Validation = &CustomResourceValidation{}
			}
			if err := m.Validation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CustomResourceDefinitionStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomResourceDefinitionStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomResourceDefinitionStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conditions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Conditions = append(m.Conditions, &CustomResourceDefinitionCondition{})
			if err := m.Conditions[len(m.Conditions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcceptedNames", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AcceptedNames == nil {
				m.AcceptedNames = &CustomResourceDefinitionNames{}
			}
			if err := m.AcceptedNames.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CustomResourceValidation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomResourceValidation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomResourceValidation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpenAPIV3Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OpenAPIV3Schema == nil {
				m.OpenAPIV3Schema = &JSONSchemaProps{}
			}
			if err := m.OpenAPIV3Schema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalDocumentation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalDocumentation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalDocumentation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Description = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Url = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JSON) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JSON: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JSON: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Raw", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Raw = append(m.Raw[:0], dAtA[iNdEx:postIndex]...)
			if m.Raw == nil {
				m.Raw = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JSONSchemaProps) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JSONSchemaProps: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JSONSchemaProps: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Id = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Schema = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ref", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Ref = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Description = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Type = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Format", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Format = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Title", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Title = &s
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Default == nil {
				m.Default = &JSON{}
			}
			if err := m.Default.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Maximum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.Maximum = &v2
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExclusiveMaximum", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ExclusiveMaximum = &b
		case 11:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Minimum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.Minimum = &v2
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExclusiveMinimum", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ExclusiveMinimum = &b
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxLength", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MaxLength = &v
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinLength", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MinLength = &v
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pattern", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Pattern = &s
			iNdEx = postIndex
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxItems", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MaxItems = &v
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinItems", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MinItems = &v
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UniqueItems", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.UniqueItems = &b
		case 19:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field MultipleOf", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.MultipleOf = &v2
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Enum = append(m.Enum, &JSON{})
			if err := m.Enum[len(m.Enum)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxProperties", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MaxProperties = &v
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinProperties", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MinProperties = &v
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Required", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Required = append(m.Required, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Items == nil {
				m.Items = &JSONSchemaPropsOrArray{}
			}
			if err := m.Items.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllOf", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllOf = append(m.AllOf, &JSONSchemaProps{})
			if err := m.AllOf[len(m.AllOf)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OneOf", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OneOf = append(m.OneOf, &JSONSchemaProps{})
			if err := m.OneOf[len(m.OneOf)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AnyOf", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AnyOf = append(m.AnyOf, &JSONSchemaProps{})
			if err := m.AnyOf[len(m.AnyOf)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Not", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Not == nil {
				m.Not = &JSONSchemaProps{}
			}
			if err := m.Not.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Properties == nil {
				m.Properties = make(map[string]*JSONSchemaProps)
			}
			var mapkey string
			var mapvalue *JSONSchemaProps
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &JSONSchemaProps{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Properties[mapkey] = mapvalue
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalProperties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = &JSONSchemaPropsOrBool{}
			}
			if err := m.AdditionalProperties.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PatternProperties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PatternProperties == nil {
				m.PatternProperties = make(map[string]*JSONSchemaProps)
			}
			var mapkey string
			var mapvalue *JSONSchemaProps
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &JSONSchemaProps{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.PatternProperties[mapkey] = mapvalue
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dependencies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dependencies == nil {
				m.Dependencies = make(map[string]*JSONSchemaPropsOrStringArray)
			}
			var mapkey string
			var mapvalue *JSONSchemaPropsOrStringArray
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &JSONSchemaPropsOrStringArray{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dependencies[mapkey] = mapvalue
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalItems", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdditionalItems == nil {
				m.AdditionalItems = &JSONSchemaPropsOrBool{}
			}
			if err := m.AdditionalItems.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Definitions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Definitions == nil {
				m.Definitions = make(map[string]*JSONSchemaProps)
			}
			var mapkey string
			var mapvalue *JSONSchemaProps
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthGenerated
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &JSONSchemaProps{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Definitions[mapkey] = mapvalue
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalDocs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExternalDocs == nil {
				m.ExternalDocs = &ExternalDocumentation{}
			}
			if err := m.ExternalDocs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Example", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Example == nil {
				m.Example = &JSON{}
			}
			if err := m.Example.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JSONSchemaPropsOrArray) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JSONSchemaPropsOrArray: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JSONSchemaPropsOrArray: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schema == nil {
				m.Schema = &JSONSchemaProps{}
			}
			if err := m.Schema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JSONSchemas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JSONSchemas = append(m.JSONSchemas, &JSONSchemaProps{})
			if err := m.JSONSchemas[len(m.JSONSchemas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JSONSchemaPropsOrBool) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JSONSchemaPropsOrBool: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JSONSchemaPropsOrBool: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Allows", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Allows = &b
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schema == nil {
				m.Schema = &JSONSchemaProps{}
			}
			if err := m.Schema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JSONSchemaPropsOrStringArray) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JSONSchemaPropsOrStringArray: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JSONSchemaPropsOrStringArray: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schema == nil {
				m.Schema = &JSONSchemaProps{}
			}
			if err := m.Schema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Property", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Property = append(m.Property, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGenerated(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGenerated = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1/generated.proto", fileDescriptorGenerated)
}

var fileDescriptorGenerated = []byte{
	// 1410 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0x4f, 0x8f, 0x14, 0x45,
	0x14, 0xb7, 0x66, 0x77, 0xd9, 0xdd, 0xda, 0x85, 0x5d, 0x4a, 0x58, 0x9a, 0x75, 0x19, 0x87, 0x96,
	0xc3, 0x86, 0xc4, 0x19, 0x01, 0x63, 0x88, 0x89, 0x07, 0xfe, 0x1d, 0xf8, 0xbb, 0xa4, 0x17, 0x21,
	0x01, 0x11, 0x8a, 0xee, 0x37, 0xb3, 0xc5, 0x76, 0x57, 0x37, 0x55, 0xd5, 0xc3, 0xcc, 0x85, 0xa8,
	0xf1, 0xc0, 0x45, 0x2f, 0x92, 0xe8, 0xc1, 0x93, 0x5e, 0xfc, 0x28, 0x1e, 0xf1, 0xe8, 0xc1, 0xc4,
	0xe0, 0x37, 0xf0, 0x13, 0x98, 0xaa, 0xae, 0xe9, 0xe9, 0xf9, 0x87, 0x24, 0xf4, 0xc0, 0xad, 0x5f,
	0xd5, 0xab, 0xdf, 0xef, 0xd5, 0x7b, 0xaf, 0xde, 0x7b, 0x33, 0xf8, 0xea, 0xee, 0x69, 0x59, 0x67,
	0x71, 0x83, 0x26, 0x0c, 0x3a, 0x0a, 0xb8, 0x64, 0x31, 0x97, 0x1f, 0xd2, 0x84, 0x49, 0x10, 0x6d,
	0x10, 0x8d, 0x64, 0xb7, 0xa5, 0xf7, 0xe4, 0xa0, 0x42, 0xa3, 0x7d, 0xe2, 0x01, 0x28, 0x7a, 0xa2,
	0xd1, 0x02, 0x0e, 0x82, 0x2a, 0x08, 0xea, 0x89, 0x88, 0x55, 0x4c, 0x3e, 0xcb, 0xe0, 0xea, 0x03,
	0xda, 0xf7, 0x72, 0xb8, 0x7a, 0xb2, 0xdb, 0xd2, 0x7b, 0x72, 0x50, 0xa1, 0x6e, 0xe1, 0xd6, 0x3f,
	0xee, 0x5b, 0x13, 0x51, 0x7f, 0x87, 0x71, 0x10, 0xdd, 0xbe, 0x09, 0x11, 0x28, 0xda, 0x68, 0x8f,
	0x90, 0xae, 0x37, 0x26, 0x9d, 0x12, 0x29, 0x57, 0x2c, 0x82, 0x91, 0x03, 0x9f, 0xfc, 0xdf, 0x01,
	0xe9, 0xef, 0x40, 0x44, 0x47, 0xce, 0x9d, 0x9a, 0x74, 0x2e, 0x55, 0x2c, 0x6c, 0x30, 0xae, 0xa4,
	0x12, 0xc3, 0x87, 0xdc, 0xe7, 0x15, 0xec, 0x9c, 0x4b, 0xa5, 0x8a, 0x23, 0x0f, 0x64, 0x9c, 0x0a,
	0x1f, 0xce, 0x43, 0x93, 0x71, 0xa6, 0x58, 0xcc, 0xc9, 0x15, 0xbc, 0xa0, 0x6f, 0x15, 0x50, 0x45,
	0x1d, 0x54, 0x43, 0x9b, 0x4b, 0x27, 0x3f, 0xaa, 0xf7, 0x5d, 0x98, 0x93, 0xf4, 0xfd, 0xa6, 0xb5,
	0xeb, 0xed, 0x13, 0xf5, 0xad, 0x07, 0x0f, 0xc1, 0x57, 0x57, 0x41, 0x51, 0x2f, 0x47, 0x20, 0x31,
	0x9e, 0x95, 0x09, 0xf8, 0x4e, 0xc5, 0x20, 0xdd, 0xa9, 0xbf, 0x56, 0x30, 0xea, 0x93, 0x8c, 0xde,
	0x4e, 0xc0, 0xf7, 0x0c, 0x11, 0x49, 0xf1, 0x1e, 0xa9, 0xa8, 0x4a, 0xa5, 0x33, 0x63, 0x28, 0xef,
	0x4e, 0x8b, 0xd2, 0x90, 0x78, 0x96, 0xcc, 0xfd, 0x0b, 0xe1, 0xa3, 0x93, 0x54, 0xcf, 0xc5, 0x3c,
	0xc8, 0x7c, 0x4b, 0xf0, 0xac, 0xea, 0x26, 0x60, 0xfc, 0xba, 0xe8, 0x99, 0x6f, 0xb2, 0x96, 0x1b,
	0x5c, 0x31, 0xab, 0x56, 0x22, 0xb7, 0x31, 0x09, 0xa9, 0x54, 0x37, 0x04, 0xe5, 0xd2, 0x9c, 0xbe,
	0xc1, 0x22, 0xb0, 0x97, 0x3a, 0xfe, 0x6a, 0x11, 0xd1, 0x27, 0xbc, 0x31, 0x28, 0x9a, 0x53, 0x00,
	0x95, 0x31, 0x77, 0x66, 0x33, 0xce, 0x4c, 0x22, 0x0e, 0x9e, 0x8f, 0x40, 0x4a, 0xda, 0x02, 0x67,
	0xce, 0x6c, 0xf4, 0x44, 0xf7, 0x4f, 0x84, 0x37, 0x26, 0xdd, 0xef, 0x0a, 0x93, 0x8a, 0x5c, 0x1a,
	0x49, 0x9b, 0xfa, 0xab, 0x19, 0xa9, 0x4f, 0x0f, 0x25, 0x4d, 0x84, 0xe7, 0x98, 0x82, 0x48, 0x7b,
	0x64, 0x66, 0x73, 0xe9, 0xe4, 0xad, 0x29, 0x85, 0xd0, 0xcb, 0x58, 0xdc, 0x5f, 0x11, 0x3e, 0x32,
	0x49, 0xe7, 0x1a, 0x8d, 0x40, 0x6a, 0x7f, 0x25, 0x61, 0x2a, 0x68, 0x68, 0x23, 0x67, 0x25, 0xb2,
	0x8e, 0x17, 0x24, 0xe3, 0xad, 0x34, 0xa4, 0xc2, 0x46, 0x2f, 0x97, 0x49, 0x15, 0x63, 0xb9, 0x13,
	0x0b, 0x65, 0x10, 0x9c, 0x99, 0xda, 0xcc, 0xe6, 0xa2, 0x57, 0x58, 0xd1, 0xb9, 0xb0, 0xcb, 0x78,
	0x60, 0x23, 0x60, 0xbe, 0x35, 0x5e, 0xc8, 0xa4, 0xba, 0xac, 0xd7, 0xb3, 0x00, 0xe4, 0xb2, 0xfb,
	0x47, 0x65, 0x72, 0x04, 0x74, 0xfe, 0x93, 0x03, 0x78, 0xae, 0x25, 0xe2, 0x34, 0xb1, 0x36, 0x66,
	0x82, 0x0e, 0x69, 0x1b, 0x84, 0x76, 0x88, 0xb5, 0xb0, 0x27, 0x12, 0x81, 0xe7, 0xb8, 0xb5, 0x4d,
	0x87, 0xeb, 0x8b, 0x29, 0x79, 0xd9, 0xdc, 0xd6, 0xcb, 0xa8, 0xb4, 0x8d, 0xd2, 0x8f, 0x13, 0xb0,
	0xb7, 0xce, 0x04, 0xf2, 0x18, 0xe3, 0x36, 0x0d, 0x59, 0x40, 0xb5, 0xbe, 0xb9, 0x78, 0xd9, 0x41,
	0xbf, 0x99, 0xc3, 0x7b, 0x05, 0x2a, 0xf7, 0xb7, 0x0a, 0xae, 0xbe, 0xfc, 0x81, 0x93, 0xaf, 0x10,
	0xc6, 0x7e, 0xef, 0x01, 0x4b, 0x07, 0x99, 0x8c, 0xbc, 0x3f, 0x25, 0x5f, 0xe5, 0x95, 0xc2, 0x2b,
	0x70, 0x92, 0x6f, 0x10, 0xde, 0x4b, 0x7d, 0x1f, 0x12, 0x05, 0x41, 0x96, 0x4d, 0x95, 0x37, 0x10,
	0xb1, 0x41, 0x4a, 0xf7, 0x19, 0x1a, 0xee, 0x19, 0x7d, 0x9f, 0x92, 0x0e, 0x5e, 0x89, 0x13, 0xe0,
	0x67, 0xae, 0x5f, 0xbc, 0x79, 0x6a, 0xdb, 0x34, 0x2a, 0x5b, 0x03, 0xae, 0xbd, 0xa6, 0x89, 0x97,
	0xb6, 0xb7, 0xae, 0x65, 0x80, 0xd7, 0x45, 0x9c, 0x48, 0x6f, 0x98, 0xc6, 0xbd, 0x8c, 0x0f, 0x5e,
	0xe8, 0x28, 0x10, 0x9c, 0x86, 0xe7, 0x63, 0x3f, 0x8d, 0x80, 0xab, 0xcc, 0xa4, 0x1a, 0x5e, 0x0a,
	0x40, 0xfa, 0x82, 0x25, 0x26, 0xa9, 0xb2, 0x37, 0x51, 0x5c, 0x22, 0xab, 0x78, 0x26, 0x15, 0xa1,
	0x7d, 0x15, 0xfa, 0xd3, 0x75, 0xf0, 0xac, 0x26, 0xd4, 0x3b, 0x82, 0x3e, 0x36, 0x67, 0x96, 0x3d,
	0xfd, 0xe9, 0x3e, 0x3d, 0x84, 0x57, 0x86, 0x6c, 0x21, 0xfb, 0x70, 0x85, 0x05, 0x16, 0xb8, 0xc2,
	0x02, 0x53, 0xc8, 0xb3, 0xbb, 0xf7, 0x0a, 0xb9, 0x91, 0x0c, 0x1a, 0x34, 0xcd, 0x2b, 0x5b, 0xf4,
	0xf4, 0xe7, 0xb0, 0x6d, 0xb3, 0xa3, 0xb6, 0xf5, 0x1a, 0xc5, 0xdc, 0x60, 0xa3, 0x68, 0xc6, 0x22,
	0xa2, 0xca, 0xd9, 0x93, 0xe1, 0x67, 0x92, 0x7e, 0x53, 0x8a, 0xa9, 0x10, 0x9c, 0xf9, 0xec, 0x4d,
	0x19, 0x81, 0xdc, 0xc5, 0xf3, 0x01, 0x34, 0x69, 0x1a, 0x2a, 0x67, 0xc1, 0x84, 0xe2, 0x5c, 0x09,
	0xa1, 0xf0, 0x7a, 0x98, 0xa6, 0x53, 0xd0, 0x0e, 0x8b, 0xd2, 0xc8, 0x59, 0xac, 0xa1, 0x4d, 0xe4,
	0xf5, 0x44, 0x72, 0x1c, 0xaf, 0x42, 0xc7, 0x0f, 0x53, 0xc9, 0xda, 0x70, 0xd5, 0xaa, 0xe0, 0x1a,
	0xda, 0x5c, 0xf0, 0x46, 0xd6, 0x0d, 0x0a, 0xe3, 0x46, 0x65, 0xc9, 0xa2, 0x64, 0xe2, 0x20, 0x8a,
	0x55, 0x59, 0x1e, 0x46, 0xb1, 0xba, 0x1b, 0x78, 0x31, 0xa2, 0x9d, 0x2b, 0xc0, 0x5b, 0x6a, 0xc7,
	0xd9, 0x5b, 0x43, 0x9b, 0x33, 0x5e, 0x7f, 0xc1, 0xec, 0x32, 0x6e, 0x77, 0xf7, 0xd9, 0xdd, 0xde,
	0x82, 0xb6, 0x20, 0xa1, 0x4a, 0x27, 0x90, 0xb3, 0x92, 0x95, 0x47, 0x2b, 0xea, 0x5a, 0x1c, 0xd1,
	0xce, 0x45, 0xd3, 0x87, 0x56, 0xcd, 0xb1, 0x5c, 0x36, 0x7b, 0x8c, 0x67, 0x7b, 0xfb, 0xed, 0x9e,
	0x95, 0x75, 0x70, 0x53, 0xce, 0x1e, 0xa5, 0x90, 0x6d, 0x13, 0x63, 0x74, 0x71, 0x49, 0x77, 0x86,
	0x28, 0x0d, 0x15, 0x4b, 0x42, 0xd8, 0x6a, 0x3a, 0xef, 0x9a, 0x8b, 0x17, 0x56, 0xc8, 0x2d, 0x3c,
	0x0b, 0x3c, 0x8d, 0x9c, 0x03, 0xa6, 0xd6, 0x94, 0x12, 0x37, 0x03, 0x48, 0x8e, 0xe1, 0xbd, 0x11,
	0xed, 0xe8, 0xec, 0x05, 0xa1, 0x18, 0x48, 0xe7, 0xa0, 0xb1, 0x7d, 0x70, 0xd1, 0x68, 0x31, 0x5e,
	0xd0, 0x5a, 0xb3, 0x5a, 0xc5, 0x45, 0xed, 0x02, 0x01, 0x8f, 0x52, 0x26, 0x20, 0x70, 0x0e, 0x99,
	0xe6, 0x96, 0xcb, 0x64, 0xb7, 0xd7, 0xbf, 0x1d, 0x93, 0x79, 0x9f, 0x97, 0x5b, 0x04, 0xb6, 0xc4,
	0x19, 0x21, 0x68, 0xd7, 0x76, 0x6f, 0x12, 0xe0, 0x39, 0x1a, 0x86, 0x5b, 0x4d, 0xe7, 0xb0, 0x71,
	0x57, 0xd9, 0x15, 0x27, 0x03, 0xd7, 0x2c, 0x31, 0xd7, 0xe1, 0x5a, 0x9f, 0x0e, 0x8b, 0x01, 0x37,
	0x77, 0xe1, 0xdd, 0xad, 0xa6, 0xf3, 0xde, 0x94, 0xee, 0xa2, 0xc1, 0xc9, 0x7d, 0x3c, 0xc3, 0x63,
	0xe5, 0x6c, 0x4c, 0xa5, 0x42, 0x6b, 0x68, 0xf2, 0x04, 0xe3, 0xa4, 0x9f, 0x3f, 0x47, 0xcc, 0x65,
	0xbe, 0x2c, 0x97, 0xa8, 0xde, 0xcf, 0xc5, 0x0b, 0x5c, 0x89, 0xae, 0x57, 0x60, 0x24, 0x4f, 0x11,
	0x3e, 0x40, 0x83, 0xac, 0x7f, 0xd2, 0xb0, 0x90, 0xca, 0x55, 0x73, 0xe7, 0x1b, 0x65, 0x27, 0xe4,
	0xd9, 0x38, 0x0e, 0xbd, 0xb1, 0x8c, 0xe4, 0x07, 0x84, 0xf7, 0xdb, 0x92, 0x52, 0xb0, 0xe3, 0x7d,
	0xe3, 0x12, 0x28, 0xdb, 0x25, 0xc3, 0x3c, 0x99, 0x67, 0x46, 0xf9, 0xc9, 0xb7, 0x08, 0x2f, 0x07,
	0x90, 0x00, 0x0f, 0x80, 0xfb, 0xda, 0xa0, 0x5a, 0x29, 0x73, 0xcd, 0xb0, 0x41, 0xe7, 0x0b, 0x14,
	0x99, 0x2d, 0x03, 0xac, 0xe4, 0x09, 0x5e, 0xe9, 0x3b, 0x2d, 0xab, 0x97, 0x47, 0xa7, 0x18, 0xa1,
	0x61, 0x32, 0xf2, 0x35, 0xd2, 0x9d, 0xb8, 0x37, 0xf7, 0x48, 0xc7, 0x35, 0x5e, 0xb8, 0x57, 0xba,
	0x17, 0x72, 0x86, 0xcc, 0x09, 0x45, 0x4e, 0xd2, 0xc1, 0xcb, 0xd0, 0x9f, 0x60, 0xa4, 0xf3, 0x41,
	0x29, 0x0e, 0x18, 0x3b, 0x14, 0x79, 0x03, 0x4c, 0x7a, 0x44, 0x80, 0x0e, 0x8d, 0x92, 0x10, 0x9c,
	0x63, 0x25, 0x8e, 0x08, 0x16, 0x73, 0xfd, 0x3b, 0x84, 0x57, 0x86, 0x52, 0x51, 0xcf, 0x42, 0xbb,
	0xd0, 0xb5, 0x43, 0x93, 0xfe, 0xd4, 0x25, 0xaf, 0x4d, 0xc3, 0x14, 0xec, 0x4c, 0x5b, 0x7a, 0xc9,
	0x33, 0xe0, 0x9f, 0x56, 0x4e, 0xa3, 0xf5, 0x67, 0x08, 0xaf, 0x8d, 0x7f, 0x21, 0x6f, 0xd5, 0xac,
	0x9f, 0x11, 0xde, 0x3f, 0xf2, 0x4e, 0xc6, 0x58, 0xf4, 0x68, 0xd0, 0xa2, 0x3b, 0x65, 0xbf, 0x90,
	0x6d, 0x25, 0x18, 0x6f, 0xd9, 0xd6, 0xda, 0x37, 0xef, 0x7b, 0x84, 0x57, 0x87, 0x13, 0xf8, 0x6d,
	0xfa, 0xcb, 0xfd, 0x17, 0xe1, 0xb5, 0xf1, 0x13, 0x01, 0x69, 0xe6, 0x13, 0xf8, 0x74, 0x7e, 0x7d,
	0xf4, 0x26, 0xfa, 0x04, 0x2f, 0x3d, 0xcc, 0xb7, 0x7a, 0xff, 0x52, 0x94, 0x4d, 0x56, 0xa4, 0x70,
	0x7f, 0x44, 0xf8, 0xe0, 0xd8, 0x9a, 0xa6, 0x7f, 0x15, 0xd0, 0x30, 0x8c, 0x1f, 0x4b, 0x73, 0xe7,
	0x05, 0xcf, 0x4a, 0x05, 0x5f, 0x54, 0xa6, 0xe9, 0x0b, 0xf7, 0x17, 0x84, 0x37, 0x5e, 0x96, 0x4b,
	0x6f, 0x2c, 0x28, 0xeb, 0x78, 0xc1, 0x4e, 0x00, 0x5d, 0x13, 0x91, 0x45, 0x2f, 0x97, 0xcf, 0x1e,
	0xfe, 0xfd, 0x45, 0x15, 0x3d, 0x7f, 0x51, 0x45, 0x7f, 0xbf, 0xa8, 0xa2, 0x9f, 0xfe, 0xa9, 0xbe,
	0x73, 0x7b, 0xde, 0xc2, 0xfd, 0x17, 0x00, 0x00, 0xff, 0xff, 0xaa, 0x01, 0xf6, 0x76, 0x6e, 0x16,
	0x00, 0x00,
}
