/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.exolab.jmscts.core.MessageComparer;
import org.exolab.jmscts.core.MessageTypes;

public class AbstractMessageComparer
implements MessageComparer {
    public boolean compare(Message message1, Message message2) throws Exception {
        boolean equal;
        if (message1 == null) {
            throw new IllegalArgumentException("Argument message1 is null");
        }
        if (message2 == null) {
            throw new IllegalArgumentException("Argument message2 is null");
        }
        boolean bl = equal = message1 == message2;
        if (!equal) {
            Class type1 = MessageTypes.getType(message1);
            Class type2 = MessageTypes.getType(message2);
            if (type1 == BytesMessage.class && type2 == BytesMessage.class) {
                equal = this.compareBytesMessages((BytesMessage)message1, (BytesMessage)message2);
            } else if (type1 == MapMessage.class && type2 == MapMessage.class) {
                equal = this.compareMapMessages((MapMessage)message1, (MapMessage)message2);
            } else if (type1 == ObjectMessage.class && type2 == ObjectMessage.class) {
                equal = this.compareObjectMessages((ObjectMessage)message1, (ObjectMessage)message2);
            } else if (type1 == StreamMessage.class && type2 == StreamMessage.class) {
                equal = this.compareStreamMessages((StreamMessage)message1, (StreamMessage)message2);
            } else if (type1 == TextMessage.class && type2 == TextMessage.class) {
                equal = this.compareTextMessages((TextMessage)message1, (TextMessage)message2);
            } else if (type1 == Message.class && type2 == Message.class) {
                equal = this.compareMessages(message1, message2);
            }
        }
        return equal;
    }

    public boolean compareMessages(Message message1, Message message2) throws Exception {
        return false;
    }

    public boolean compareBytesMessages(BytesMessage message1, BytesMessage message2) throws Exception {
        return false;
    }

    public boolean compareMapMessages(MapMessage message1, MapMessage message2) throws Exception {
        return false;
    }

    public boolean compareObjectMessages(ObjectMessage message1, ObjectMessage message2) throws Exception {
        return false;
    }

    public boolean compareStreamMessages(StreamMessage message1, StreamMessage message2) throws Exception {
        return false;
    }

    public boolean compareTextMessages(TextMessage message1, TextMessage message2) throws Exception {
        return false;
    }
}

