/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.Message;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.AttributeHelper;
import org.exolab.jmscts.core.DeliveryTypes;
import org.exolab.jmscts.core.DestinationHelper;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessagingHelper;
import org.exolab.jmscts.core.SendReceiveTestCase;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;

public abstract class AbstractSendReceiveTestCase
extends AbstractMessageTestCase
implements SendReceiveTestCase {
    private Map _destinations = null;
    private static final Category log = Category.getInstance((Class)AbstractSendReceiveTestCase.class);

    public AbstractSendReceiveTestCase(String name) {
        super(name);
    }

    public String[] getDestinations() {
        return null;
    }

    public void setDestinations(Map destinations) {
        this._destinations = destinations;
    }

    public Destination getDestination(String name) {
        return (Destination)this._destinations.get(name);
    }

    public DeliveryTypes getDeliveryTypes() {
        DeliveryTypes result = null;
        String test = this.getName();
        String[] types = AttributeHelper.getAttributes(this.getClass(), test, "jmscts.delivery", false);
        result = types.length == 0 ? DeliveryTypes.ALL : DeliveryTypes.fromString(types);
        return result;
    }

    public boolean getDurableOnly() {
        String test = this.getName();
        return AttributeHelper.getBoolean(this.getClass(), test, "jmscts.durableonly", false);
    }

    protected void send(Message message, Destination destination) throws Exception {
        this.send(this.getContext(), message, destination, 1);
    }

    protected void send(Message message, String name) throws Exception {
        Destination destination = this.getDestination(name);
        if (destination == null) {
            throw new Exception("No destination associated with name=" + name + " exists");
        }
        this.send(message, destination);
    }

    protected void send(Destination destination, int count) throws Exception {
        this.send(this.getContext(), destination, count);
    }

    protected void send(String name, int count) throws Exception {
        Destination destination = this.getDestination(name);
        if (destination == null) {
            throw new Exception("No destination associated with name=" + name + " exists");
        }
        this.send(destination, count);
    }

    protected void send(TestContext context, String name, int count) throws Exception {
        Destination destination = this.getDestination(name);
        if (destination == null) {
            throw new Exception("No destination associated with name=" + name + " exists");
        }
        this.send(context, destination, count);
    }

    protected void send(TestContext context, Destination destination, int count) throws Exception {
        this.send(context, context.getMessage(), destination, count);
    }

    protected void send(TestContext context, Message message, Destination destination, int count) throws Exception {
        MessagingHelper.send(context, message, destination, count);
    }

    protected Message sendReceive(Message message, Destination destination) throws Exception {
        return MessagingHelper.sendReceive(this.getContext(), message, destination);
    }

    protected Message sendReceive(Message message, String name) throws Exception {
        Destination destination = this.getDestination(name);
        if (destination == null) {
            throw new Exception("No destination associated with name=" + name + " exists");
        }
        return this.sendReceive(message, destination);
    }

    protected MessageReceiver createReceiver(String name) throws Exception {
        return this.createReceiver(this.getContext(), name);
    }

    protected MessageReceiver createReceiver(TestContext context, String name) throws Exception {
        Destination destination = this.getDestination(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating receiver for destination=" + DestinationHelper.getName(destination)));
        }
        return SessionHelper.createReceiver(context, destination);
    }

    protected MessageReceiver[] createReceivers() throws Exception {
        return this.createReceivers(this.getContext());
    }

    protected MessageReceiver[] createReceivers(TestContext context) throws Exception {
        String[] destinations = this.getDestinations();
        MessageReceiver[] receivers = new MessageReceiver[destinations.length];
        for (int i = 0; i < destinations.length; ++i) {
            receivers[i] = this.createReceiver(context, destinations[i]);
        }
        return receivers;
    }

    protected MessageReceiver recreate(MessageReceiver receiver) throws Exception {
        Destination destination = receiver.getDestination();
        String name = receiver.getName();
        String selector = receiver.getSelector();
        boolean noLocal = receiver.getNoLocal();
        receiver.close();
        return SessionHelper.createReceiver(this.getContext(), destination, name, selector, noLocal);
    }

    protected MessageSender createSender(String name) throws Exception {
        return this.createSender(this.getContext(), name);
    }

    protected MessageSender createSender(TestContext context, String name) throws Exception {
        Destination destination = this.getDestination(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating sender for destination=" + DestinationHelper.getName(destination)));
        }
        return SessionHelper.createSender(context, destination);
    }

    protected MessageSender[] createSenders() throws Exception {
        return this.createSenders(this.getContext());
    }

    protected MessageSender[] createSenders(TestContext context) throws Exception {
        String[] destinations = this.getDestinations();
        MessageSender[] senders = new MessageSender[destinations.length];
        for (int i = 0; i < destinations.length; ++i) {
            senders[i] = this.createSender(context, destinations[i]);
        }
        return senders;
    }

    protected void receive(MessageReceiver[] receivers, int count) throws Exception {
        TestContext context = this.getContext();
        for (int i = 0; i < receivers.length; ++i) {
            this.receive(context, receivers[i], count);
        }
    }

    protected void receive(TestContext context, MessageReceiver[] receivers, int count) throws Exception {
        for (int i = 0; i < receivers.length; ++i) {
            this.receive(context, receivers[i], count);
        }
    }

    protected Message receive(MessageReceiver receiver) throws Exception {
        return this.receive(this.getContext(), receiver);
    }

    protected Message receive(TestContext context, MessageReceiver receiver) throws Exception {
        List messages = this.receive(context, receiver, 1);
        return (Message)messages.get(0);
    }

    protected List receive(MessageReceiver receiver, int count) throws Exception {
        return this.receive(this.getContext(), receiver, count);
    }

    protected List receive(TestContext context, MessageReceiver receiver, int count) throws Exception {
        String name = DestinationHelper.getName(receiver.getDestination());
        long timeout = context.getMessagingBehaviour().getTimeout();
        List result = receiver.receive(count, timeout);
        if (result == null) {
            if (count != 0) {
                String msg = "Failed to receive any messages from destination=" + name + ". Test context=" + context;
                AbstractSendReceiveTestCase.fail((String)msg);
            }
        } else if (result.size() != count) {
            String msg = "Expected " + count + " messages from destination=" + name + ", but got " + result.size() + ". Test context=" + context;
            AbstractSendReceiveTestCase.fail((String)msg);
        }
        return result;
    }

    protected void send(MessageSender[] senders, Message message, int count) throws Exception {
        for (int i = 0; i < senders.length; ++i) {
            senders[i].send(message, count);
        }
    }

    protected void close(MessageReceiver[] receivers) throws Exception {
        for (int i = 0; i < receivers.length; ++i) {
            this.close(receivers[i]);
            receivers[i] = null;
        }
    }

    protected void close(MessageReceiver receiver) throws Exception {
        if (receiver != null) {
            if (log.isDebugEnabled()) {
                Destination destination = receiver.getDestination();
                log.debug((Object)("Closing receiver for destination=" + DestinationHelper.getName(destination)));
            }
            receiver.remove();
        }
    }

    protected void close(MessageSender[] senders) throws Exception {
        for (int i = 0; i < senders.length; ++i) {
            this.close(senders[i]);
            senders[i] = null;
        }
    }

    protected void close(MessageSender sender) throws Exception {
        if (sender != null) {
            if (log.isDebugEnabled()) {
                Destination destination = sender.getDestination();
                log.debug((Object)("Closing sender for destination=" + DestinationHelper.getName(destination)));
            }
            sender.close();
        }
    }
}

