/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Iterator;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.log4j.Category;
import org.apache.log4j.xml.DOMConfigurator;
import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceGroup;
import org.exolab.core.service.Serviceable;
import org.exolab.core.util.RmiRegistryService;
import org.exolab.jmscts.core.ProviderTestRunner;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestFilter;
import org.exolab.jmscts.core.filter.Filter;
import org.exolab.jmscts.core.service.SnapshotService;
import org.exolab.jmscts.core.service.TestTerminatorService;
import org.exolab.jmscts.provider.Configuration;
import org.exolab.jmscts.provider.ProviderLoader;

public abstract class AbstractTestRunner
extends TestSetup {
    public static final String DEFAULT_PORT = "4000";
    private static final String CONFIG = "config";
    private static final String FILTER = "filter";
    private static final String OUTPUT = "output";
    private static final String PORT = "port";
    private static final String LOG4J = "log4j.xml";
    private Configuration _config = null;
    private String _output = null;
    private Filter _filter = null;
    private final String[] _args;
    private TestResult _result = null;
    private ProviderLoader _provider = null;
    private int _port;
    private ServiceGroup _services = new ServiceGroup();
    private static final Category log = Category.getInstance((String)AbstractTestRunner.class.getName());

    public AbstractTestRunner(Class test, String[] args) {
        super((Test)new TestSuite(test));
        if (args == null) {
            throw new IllegalArgumentException("Argument 'args' is null");
        }
        this._args = args;
        DOMConfigurator.configure((String)(this.getHome() + "/config/" + LOG4J));
    }

    public AbstractTestRunner(Test test, String[] args) {
        super(test);
        if (args == null) {
            throw new IllegalArgumentException("Argument args is null");
        }
        this._args = args;
        DOMConfigurator.configure((String)(this.getHome() + "/config/" + LOG4J));
    }

    public abstract void report(String var1) throws Exception;

    public void snapshot(String path) throws Exception {
        this.report(path);
    }

    public void stop() {
        if (this._result != null) {
            this._result.stop();
        }
        try {
            this.report(this._output);
        }
        catch (Exception exception) {
            log.error((Object)"Failed to produce report", (Throwable)exception);
        }
    }

    public void abort() {
        try {
            this.report(this._output);
        }
        catch (Exception exception) {
            log.error((Object)"Failed to produce report", (Throwable)exception);
        }
        System.exit(1);
    }

    public abstract TestContext createContext();

    public void basicRun(TestResult result) {
        TestFilter filter = this._filter != null ? new TestFilter(this._filter) : null;
        this._result = result;
        Iterator iterator = this._config.getProviders().iterator();
        while (iterator.hasNext() && !result.shouldStop()) {
            this._provider = (ProviderLoader)iterator.next();
            TestSuite suite = new TestSuite();
            this.mergeSuites(suite, this.getTest());
            TestContext context = this.createContext();
            ProviderTestRunner runner = new ProviderTestRunner((Test)suite);
            runner.setContext(context);
            runner.setFilter(filter);
            runner.setProvider(this._provider);
            runner.run(result);
            try {
                this.report(this._output);
            }
            catch (Exception exception) {
                log.error((Object)exception, (Throwable)exception);
            }
        }
    }

    public int getPort() {
        return this._port;
    }

    protected void setUp() throws Exception {
        Options options = new Options();
        options.addOption(CONFIG, true, "the provider configuration path");
        options.addOption(OUTPUT, true, "the output path");
        options.addOption(FILTER, true, "the test case filter path");
        options.addOption(PORT, true, "registry port");
        GnuParser parser = new GnuParser();
        CommandLine commands = parser.parse(options, this._args);
        String config = commands.getOptionValue(CONFIG, this.getHome() + "/config/providers.xml");
        this._output = commands.getOptionValue(OUTPUT, this.getHome() + "/report");
        File dir = new File(this._output);
        if (!dir.isDirectory()) {
            throw new Exception("Invalid output directory: " + this._output);
        }
        if (!dir.canWrite()) {
            throw new Exception("Cannot write to output directory: " + this._output);
        }
        String filter = commands.getOptionValue(FILTER);
        this._port = Integer.parseInt(commands.getOptionValue(PORT, DEFAULT_PORT));
        this._config = Configuration.read(config);
        this.loadFilter(filter);
        this.startServices();
    }

    protected ProviderLoader getProvider() {
        return this._provider;
    }

    protected void tearDown() throws Exception {
        this._config = null;
        if (this._services != null) {
            this._services.stopAll();
        }
    }

    protected void startServices() throws Exception {
        this.registerServices(this._services);
        this._services.startAll();
    }

    protected void registerServices(ServiceGroup services) throws ServiceException {
        RmiRegistryService registry = new RmiRegistryService(this._port);
        services.add(registry.getName(), (Serviceable)registry);
        SnapshotService snapshot = new SnapshotService(this, this._port);
        services.add(snapshot.getName(), (Serviceable)snapshot);
        TestTerminatorService terminator = new TestTerminatorService(this, this._port);
        services.add(terminator.getName(), (Serviceable)terminator);
        services.startAll();
    }

    protected String getHome() {
        return System.getProperty("jmscts.home", System.getProperty("user.dir"));
    }

    protected void mergeSuites(TestSuite suite, Test test) {
        if (test instanceof TestSuite) {
            Enumeration iter = ((TestSuite)test).tests();
            while (iter.hasMoreElements()) {
                this.mergeSuites(suite, (Test)iter.nextElement());
            }
        } else {
            suite.addTest(test);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFilter(String filter) throws Exception {
        if (filter != null) {
            FileReader filterReader = null;
            try {
                filterReader = new FileReader(filter);
                this._filter = Filter.unmarshal(filterReader);
            }
            finally {
                if (filterReader != null) {
                    filterReader.close();
                }
            }
        }
    }
}

