/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

public final class AckType {
    public static final AckType TRANSACTED = new AckType();
    public static final AckType AUTO_ACKNOWLEDGE = new AckType(1);
    public static final AckType CLIENT_ACKNOWLEDGE = new AckType(2);
    public static final AckType DUPS_OK_ACKNOWLEDGE = new AckType(3);
    private final boolean _transacted;
    private final int _acknowledgeMode;

    private AckType() {
        this._transacted = true;
        this._acknowledgeMode = 1;
    }

    private AckType(int acknowledgeMode) {
        this._transacted = false;
        this._acknowledgeMode = acknowledgeMode;
    }

    public boolean getTransacted() {
        return this._transacted;
    }

    public int getAcknowledgeMode() {
        return this._acknowledgeMode;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof AckType) {
            AckType type = (AckType)obj;
            if (this._transacted == type._transacted && this._acknowledgeMode == type._acknowledgeMode) {
                equal = true;
            }
        }
        return equal;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String result = null;
        if (this._transacted) {
            result = "TRANSACTED";
        } else {
            switch (this._acknowledgeMode) {
                case 1: {
                    result = "AUTO_ACKNOWLEDGE";
                    break;
                }
                case 2: {
                    result = "CLIENT_ACKNOWLEDGE";
                    break;
                }
                default: {
                    result = "DUPS_OK_ACKNOWLEDGE";
                }
            }
        }
        return result;
    }

    public static AckType fromString(String type) {
        AckType result = null;
        if (type.equalsIgnoreCase("AUTO_ACKNOWLEDGE")) {
            result = AUTO_ACKNOWLEDGE;
        } else if (type.equalsIgnoreCase("CLIENT_ACKNOWLEDGE")) {
            result = CLIENT_ACKNOWLEDGE;
        } else if (type.equalsIgnoreCase("DUPS_OK_ACKNOWLEDGE")) {
            result = DUPS_OK_ACKNOWLEDGE;
        } else if (type.equalsIgnoreCase("TRANSACTED")) {
            result = TRANSACTED;
        } else {
            throw new IllegalArgumentException("Invalid ack type: " + type);
        }
        return result;
    }
}

