/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.io.OutputStream;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.ApplicationRunner;
import org.exolab.jmscts.core.ExecutionListener;
import org.exolab.jmscts.core.Executor;
import org.exolab.jmscts.core.service.ExecutionMonitorService;

public class AsyncExecutor {
    private String _command = null;
    private Executor _executor = null;
    private String _id = null;
    private static final Category log = Category.getInstance((String)AsyncExecutor.class.getName());

    public AsyncExecutor(Class application, String arguments, int port) {
        this(application, arguments, System.out, System.err, port);
    }

    public AsyncExecutor(Class application, String arguments, OutputStream out, int port) {
        this(application, arguments, out, out, port);
    }

    public AsyncExecutor(Class application, String arguments, OutputStream out, OutputStream err, int port) {
        if (application == null) {
            throw new IllegalArgumentException("Argument application is null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null");
        }
        if (err == null) {
            throw new IllegalArgumentException("Argument err is null");
        }
        this._id = ExecutionMonitorService.instance().allocateId();
        StringBuffer command = new StringBuffer();
        command.append(System.getProperty("java.home"));
        command.append("/bin/java ");
        String policy = System.getProperty("java.security.policy");
        if (policy != null) {
            command.append(" -Djava.security.policy=");
            command.append(policy);
            command.append(" ");
        }
        command.append(" -classpath ");
        command.append(System.getProperty("java.class.path"));
        command.append(" ");
        command.append(ApplicationRunner.class.getName());
        command.append(" ");
        command.append(this._id);
        command.append(" ");
        command.append(port);
        command.append(" ");
        command.append(application.getName());
        if (arguments != null) {
            command.append(" ");
            command.append(arguments);
        }
        this._command = command.toString();
    }

    public void addListener(ExecutionListener listener) {
        ExecutionMonitorService.instance().addListener(this._id, listener);
    }

    public void removeListener(ExecutionListener listener) {
        ExecutionMonitorService.instance().removeListener(this._id, listener);
    }

    public synchronized void run() {
        if (this._executor == null) {
            this._executor = new Executor(this._command);
        }
        Thread thread = new Thread(){

            public void run() {
                try {
                    int status = AsyncExecutor.this._executor.run();
                    ExecutionMonitorService.instance().stopped(AsyncExecutor.this._id, status);
                }
                catch (Exception exception) {
                    ExecutionMonitorService.instance().failed(AsyncExecutor.this._id, exception);
                }
            }
        };
        log.debug((Object)("running command=" + this._command));
        thread.start();
    }

    public void stop() {
        if (this._executor != null) {
            this._executor.stop();
        }
    }
}

