/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.meta.Attribute;
import org.exolab.jmscts.core.meta.ClassMeta;
import org.exolab.jmscts.core.meta.Meta;
import org.exolab.jmscts.core.meta.MetaData;
import org.exolab.jmscts.core.meta.MethodMeta;

public final class AttributeHelper {
    private static final HashMap METADATA;
    private static final Category log;
    private static final String[] EMPTY;
    private static final String PATH = "/metadata.xml";

    private AttributeHelper() {
    }

    public static boolean getBoolean(Class clazz, String attribute) {
        boolean result = false;
        String[] values = AttributeHelper.getAttributes(clazz, attribute);
        return result;
    }

    public static boolean getBoolean(Class clazz, String methodName, String attribute) {
        String[] values = AttributeHelper.getAttributes(clazz, methodName, attribute);
        return AttributeHelper.getBoolean(values);
    }

    public static boolean getBoolean(Class clazz, String methodName, String attribute, boolean all) {
        String[] values = AttributeHelper.getAttributes(clazz, methodName, attribute, all);
        return AttributeHelper.getBoolean(values);
    }

    public static String[] getAttributes(Class clazz, String attribute) {
        String[] result = EMPTY;
        ClassMeta meta = (ClassMeta)METADATA.get(clazz.getName());
        if (meta != null) {
            result = AttributeHelper.getValues(meta, attribute);
        } else {
            log.warn((Object)("Failed to locate meta data for class=" + clazz.getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attribute values for " + clazz.getName() + "[" + attribute + "] = " + AttributeHelper.format(result)));
        }
        return result;
    }

    public static String[] getAttributes(Class clazz, String methodName, String attribute, boolean all) {
        String[] result = EMPTY;
        String[] methodAtts = EMPTY;
        String[] classAtts = EMPTY;
        if (methodName != null) {
            methodAtts = AttributeHelper.getAttributes(clazz, methodName, attribute);
        }
        if (methodAtts.length == 0 || all) {
            classAtts = AttributeHelper.getAttributes(clazz, attribute);
        }
        if (methodAtts.length != 0 || classAtts.length != 0) {
            result = new String[methodAtts.length + classAtts.length];
            System.arraycopy(methodAtts, 0, result, 0, methodAtts.length);
            System.arraycopy(classAtts, 0, result, methodAtts.length, classAtts.length);
        }
        return result;
    }

    public static String[] getAttributes(Class clazz, String methodName, String attribute) {
        String[] result = EMPTY;
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            result = AttributeHelper.getAttributes(method, attribute);
        }
        catch (Exception exception) {
            log.warn((Object)("Failed to locate meta data for class=" + clazz.getName()), (Throwable)exception);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attribute values for " + clazz.getName() + "." + methodName + "[" + attribute + "] = " + AttributeHelper.format(result)));
        }
        return result;
    }

    public static String[] getAttributes(Method method, String attribute) {
        String[] result = EMPTY;
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        ClassMeta classMeta = (ClassMeta)METADATA.get(className);
        if (classMeta != null) {
            MethodMeta[] methods = classMeta.getMethodMeta();
            for (int i = 0; i < methods.length; ++i) {
                MethodMeta methodMeta = methods[i];
                if (!methodMeta.getName().equals(methodName)) continue;
                result = AttributeHelper.getValues(methodMeta, attribute);
            }
        } else {
            log.warn((Object)("Failed to locate meta data for class=" + className));
        }
        return result;
    }

    private static boolean getBoolean(String[] values) {
        boolean result = false;
        if (values.length > 0) {
            result = Boolean.valueOf(values[0]);
        }
        return result;
    }

    private static String[] getValues(Meta meta, String name) {
        ArrayList<String> result = new ArrayList<String>();
        Attribute[] attributes = meta.getAttribute();
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            if (!attribute.getName().equals(name)) continue;
            result.add(attribute.getValue());
        }
        return result.toArray(EMPTY);
    }

    private static String format(String[] values) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(values[i]);
        }
        return result.toString();
    }

    static {
        MetaData metaData;
        log = Category.getInstance((String)AttributeHelper.class.getName());
        EMPTY = new String[0];
        METADATA = new HashMap();
        InputStream stream = AttributeHelper.class.getResourceAsStream(PATH);
        if (stream == null) {
            String msg = "Failed to locate meta data: /metadata.xml";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            metaData = MetaData.unmarshal(new InputStreamReader(stream));
        }
        catch (Exception exception) {
            String msg = "Failed to read meta data: /metadata.xml";
            log.error((Object)msg, (Throwable)exception);
            throw new RuntimeException(msg);
        }
        ClassMeta[] classes = metaData.getClassMeta();
        for (int i = 0; i < classes.length; ++i) {
            ClassMeta clazz = classes[i];
            METADATA.put(clazz.getName(), clazz);
        }
    }
}

