/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Connection;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.ConnectionFactoryHelper;
import org.exolab.jmscts.core.ConnectionFactoryTestCase;
import org.exolab.jmscts.core.ConnectionFactoryTypes;
import org.exolab.jmscts.core.ConnectionTestCase;
import org.exolab.jmscts.core.JMSTest;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestFilter;
import org.exolab.jmscts.core.TestInvoker;
import org.exolab.jmscts.core.TestRunner;

public class ConnectionTestRunner
extends TestRunner
implements ConnectionFactoryTestCase {
    private static final Category log = Category.getInstance((String)ConnectionTestRunner.class.getName());

    public ConnectionTestRunner(ConnectionTestCase test) {
        super(test);
    }

    public ConnectionFactoryTypes getConnectionFactoryTypes() {
        return ((ConnectionTestCase)this.getTest()).getConnectionFactoryTypes();
    }

    protected void runTest(Test test, TestResult result) {
        Tester tester = new Tester(test, result, this.getContext(), this.getFilter());
        result.runProtected(test, (Protectable)tester);
    }

    private class Tester
    extends TestInvoker {
        public Tester(Test test, TestResult result, TestContext context, TestFilter filter) {
            super(test, result, context, filter);
        }

        protected void setUp(JMSTest test, TestContext context) throws Exception {
            ConnectionTestCase connectionTest = (ConnectionTestCase)test;
            Connection connection = null;
            String clientID = null;
            connection = ConnectionFactoryHelper.createConnection(context, clientID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ConnectionTestRunner: running test=" + test + " using connection type=" + connection.getClass().getName()));
            }
            TestContext child = new TestContext(context, connection);
            ConnectionTestRunner.this.setChildContext(child);
            connectionTest.setContext(child);
            if (connectionTest.startConnection()) {
                try {
                    connection.start();
                }
                catch (Exception exception) {
                    log.error((Object)exception, (Throwable)exception);
                    throw exception;
                }
            }
        }

        protected void tearDown(JMSTest test, TestContext context) throws Exception {
            ConnectionTestCase connectionTest = (ConnectionTestCase)test;
            Connection connection = ConnectionTestRunner.this.getChildContext().getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)("ConnectionTestRunner: completed test=" + test + " using connection type=" + connection.getClass().getName()));
            }
            connection.close();
        }
    }
}

