/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import org.exolab.jmscts.core.DeliveryType;
import org.exolab.jmscts.core.ReceiptType;

public class DeliveryTypes {
    public static final DeliveryType SEND_NON_PERSISTENT_ADMINISTERED = new DeliveryType(false, true);
    public static final DeliveryType SEND_PERSISTENT_ADMINISTERED = new DeliveryType(true, true);
    public static final DeliveryType SEND_NON_PERSISTENT_TEMPORARY = new DeliveryType(false, false);
    public static final DeliveryType SEND_PERSISTENT_TEMPORARY = new DeliveryType(true, false);
    public static final DeliveryTypes ALL_SEND = new DeliveryTypes(new DeliveryType[]{SEND_NON_PERSISTENT_ADMINISTERED, SEND_PERSISTENT_ADMINISTERED, SEND_NON_PERSISTENT_TEMPORARY, SEND_PERSISTENT_TEMPORARY});
    public static final DeliveryType NON_PERSISTENT_ADMINISTERED_SYNC = new DeliveryType(false, true, ReceiptType.SYNCHRONOUS);
    public static final DeliveryType NON_PERSISTENT_ADMINISTERED_ASYNC = new DeliveryType(false, true, ReceiptType.ASYNCHRONOUS);
    public static final DeliveryType NON_PERSISTENT_ADMINISTERED_BROWSER = new DeliveryType(false, true, ReceiptType.BROWSER);
    public static final DeliveryType NON_PERSISTENT_TEMPORARY_SYNC = new DeliveryType(false, false, ReceiptType.SYNCHRONOUS);
    public static final DeliveryType NON_PERSISTENT_TEMPORARY_ASYNC = new DeliveryType(false, false, ReceiptType.ASYNCHRONOUS);
    public static final DeliveryType NON_PERSISTENT_TEMPORARY_BROWSER = new DeliveryType(false, false, ReceiptType.BROWSER);
    public static final DeliveryType PERSISTENT_ADMINISTERED_SYNC = new DeliveryType(true, true, ReceiptType.SYNCHRONOUS);
    public static final DeliveryType PERSISTENT_ADMINISTERED_ASYNC = new DeliveryType(true, true, ReceiptType.ASYNCHRONOUS);
    public static final DeliveryType PERSISTENT_ADMINISTERED_BROWSER = new DeliveryType(true, true, ReceiptType.BROWSER);
    public static final DeliveryType PERSISTENT_TEMPORARY_SYNC = new DeliveryType(true, false, ReceiptType.SYNCHRONOUS);
    public static final DeliveryType PERSISTENT_TEMPORARY_ASYNC = new DeliveryType(true, false, ReceiptType.ASYNCHRONOUS);
    public static final DeliveryType PERSISTENT_TEMPORARY_BROWSER = new DeliveryType(true, false, ReceiptType.BROWSER);
    public static final DeliveryTypes NON_PERSISTENT = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_ADMINISTERED_SYNC, NON_PERSISTENT_ADMINISTERED_ASYNC, NON_PERSISTENT_ADMINISTERED_BROWSER, NON_PERSISTENT_TEMPORARY_SYNC, NON_PERSISTENT_TEMPORARY_ASYNC, NON_PERSISTENT_TEMPORARY_BROWSER});
    public static final DeliveryTypes PERSISTENT = new DeliveryTypes(new DeliveryType[]{PERSISTENT_ADMINISTERED_SYNC, PERSISTENT_ADMINISTERED_ASYNC, PERSISTENT_ADMINISTERED_BROWSER, PERSISTENT_TEMPORARY_SYNC, PERSISTENT_TEMPORARY_ASYNC, PERSISTENT_TEMPORARY_BROWSER});
    public static final DeliveryTypes SYNCHRONOUS = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_ADMINISTERED_SYNC, NON_PERSISTENT_TEMPORARY_SYNC, PERSISTENT_ADMINISTERED_SYNC, PERSISTENT_TEMPORARY_SYNC});
    public static final DeliveryTypes ASYNCHRONOUS = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_ADMINISTERED_ASYNC, NON_PERSISTENT_TEMPORARY_ASYNC, PERSISTENT_ADMINISTERED_ASYNC, PERSISTENT_TEMPORARY_ASYNC});
    public static final DeliveryTypes TEMPORARY = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_TEMPORARY_SYNC, NON_PERSISTENT_TEMPORARY_ASYNC, NON_PERSISTENT_TEMPORARY_BROWSER, PERSISTENT_TEMPORARY_SYNC, PERSISTENT_TEMPORARY_ASYNC, PERSISTENT_TEMPORARY_BROWSER});
    public static final DeliveryTypes ADMINISTERED = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_ADMINISTERED_SYNC, NON_PERSISTENT_ADMINISTERED_ASYNC, NON_PERSISTENT_ADMINISTERED_BROWSER, PERSISTENT_ADMINISTERED_SYNC, PERSISTENT_ADMINISTERED_ASYNC, PERSISTENT_ADMINISTERED_BROWSER});
    public static final DeliveryTypes NON_PERSISTENT_CONSUMER = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_ADMINISTERED_SYNC, NON_PERSISTENT_ADMINISTERED_ASYNC, NON_PERSISTENT_TEMPORARY_SYNC, NON_PERSISTENT_TEMPORARY_ASYNC});
    public static final DeliveryTypes PERSISTENT_CONSUMER = new DeliveryTypes(new DeliveryType[]{PERSISTENT_ADMINISTERED_SYNC, PERSISTENT_ADMINISTERED_ASYNC, PERSISTENT_TEMPORARY_SYNC, PERSISTENT_TEMPORARY_ASYNC});
    public static final DeliveryTypes ADMINISTERED_CONSUMER = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_ADMINISTERED_SYNC, NON_PERSISTENT_ADMINISTERED_ASYNC, PERSISTENT_ADMINISTERED_SYNC, PERSISTENT_ADMINISTERED_ASYNC});
    public static final DeliveryTypes TEMPORARY_CONSUMER = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_TEMPORARY_SYNC, NON_PERSISTENT_TEMPORARY_ASYNC, PERSISTENT_TEMPORARY_SYNC, PERSISTENT_TEMPORARY_ASYNC});
    public static final DeliveryTypes CONSUMER = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_ADMINISTERED_SYNC, NON_PERSISTENT_ADMINISTERED_ASYNC, NON_PERSISTENT_TEMPORARY_SYNC, NON_PERSISTENT_TEMPORARY_ASYNC, PERSISTENT_ADMINISTERED_SYNC, PERSISTENT_ADMINISTERED_ASYNC, PERSISTENT_TEMPORARY_SYNC, PERSISTENT_TEMPORARY_ASYNC});
    public static final DeliveryTypes ALL = new DeliveryTypes(new DeliveryType[]{NON_PERSISTENT_ADMINISTERED_SYNC, NON_PERSISTENT_ADMINISTERED_ASYNC, NON_PERSISTENT_ADMINISTERED_BROWSER, NON_PERSISTENT_TEMPORARY_SYNC, NON_PERSISTENT_TEMPORARY_ASYNC, NON_PERSISTENT_TEMPORARY_BROWSER, PERSISTENT_ADMINISTERED_SYNC, PERSISTENT_ADMINISTERED_ASYNC, PERSISTENT_ADMINISTERED_BROWSER, PERSISTENT_TEMPORARY_SYNC, PERSISTENT_TEMPORARY_ASYNC, PERSISTENT_TEMPORARY_BROWSER});
    private final DeliveryType[] _types;

    public DeliveryTypes(DeliveryType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument type is null");
        }
        this._types = new DeliveryType[]{type};
    }

    public DeliveryTypes(DeliveryType[] types) {
        if (types == null) {
            throw new IllegalArgumentException("Argument types is null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("Argument types has no elements");
        }
        this._types = types;
    }

    public DeliveryType[] getTypes() {
        return this._types;
    }

    public int count() {
        return this._types.length;
    }

    public static DeliveryTypes fromString(String[] types) {
        DeliveryTypes result = null;
        DeliveryType[] set = new DeliveryType[types.length];
        for (int i = 0; i < types.length; ++i) {
            if ("all".equalsIgnoreCase(types[i])) {
                result = ALL;
                break;
            }
            if ("all-send".equalsIgnoreCase(types[i])) {
                result = ALL_SEND;
                break;
            }
            if ("administered-consumer".equalsIgnoreCase(types[i])) {
                result = ADMINISTERED_CONSUMER;
                break;
            }
            if ("asynchronous".equalsIgnoreCase(types[i])) {
                result = ASYNCHRONOUS;
                break;
            }
            if ("consumer".equalsIgnoreCase(types[i])) {
                result = CONSUMER;
                break;
            }
            if ("synchronous".equalsIgnoreCase(types[i])) {
                result = SYNCHRONOUS;
                break;
            }
            set[i] = DeliveryType.fromString(types[i]);
        }
        if (result == null) {
            result = new DeliveryTypes(set);
        }
        return result;
    }
}

