/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.io.OutputStream;
import org.exolab.jmscts.core.Reader;

public class Executor {
    private final String _command;
    private final OutputStream _out;
    private final OutputStream _err;
    private volatile Process _process = null;

    public Executor(String command) {
        this(command, System.out, System.err);
    }

    public Executor(String command, OutputStream log) {
        this(command, log, log);
    }

    public Executor(String command, OutputStream out, OutputStream err) {
        if (command == null) {
            throw new IllegalArgumentException("Argument 'command' is null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument 'out' is null");
        }
        if (err == null) {
            throw new IllegalArgumentException("Argument 'err' is null");
        }
        this._command = command;
        this._out = out;
        this._err = err;
    }

    public int run() throws Exception {
        Thread outStream = null;
        Thread errStream = null;
        boolean done = false;
        int status = 1;
        try {
            this._process = Runtime.getRuntime().exec(this._command);
            Reader out = new Reader(this._process.getInputStream(), this._out);
            Reader err = new Reader(this._process.getErrorStream(), this._err);
            outStream = new Thread(out);
            errStream = new Thread(err);
            outStream.start();
            errStream.start();
            while (!done) {
                try {
                    status = this._process.waitFor();
                    done = true;
                }
                catch (InterruptedException ignore) {}
            }
        }
        catch (Exception error) {
            boolean stopped;
            if (this._process != null && !done) {
                this._process.destroy();
            }
            if (outStream != null) {
                stopped = false;
                while (!stopped) {
                    try {
                        outStream.join();
                        stopped = true;
                    }
                    catch (InterruptedException ignore) {}
                }
            }
            if (errStream != null) {
                stopped = false;
                while (!stopped) {
                    try {
                        errStream.join();
                        stopped = true;
                    }
                    catch (InterruptedException ignore) {}
                }
            }
            throw error;
        }
        finally {
            outStream = null;
            errStream = null;
            this._process = null;
        }
        return status;
    }

    public void stop() {
        if (this._process != null) {
            this._process.destroy();
        }
    }
}

