/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.exolab.jmscts.core.AbstractMessageComparer;

public class MessageBodyComparer
extends AbstractMessageComparer {
    public boolean compareMessages(Message message1, Message message2) throws Exception {
        return true;
    }

    public boolean compareBytesMessages(BytesMessage message1, BytesMessage message2) throws Exception {
        int size = 1024;
        boolean equal = true;
        byte[] stream1 = new byte[1024];
        byte[] stream2 = new byte[stream1.length];
        block0: while (equal) {
            int read2;
            int read1 = message1.readBytes(stream1);
            if (read1 == (read2 = message2.readBytes(stream2))) {
                if (read1 == -1) break;
                for (int i = 0; i < read1; ++i) {
                    if (stream1[i] == stream2[i]) continue;
                    equal = false;
                    continue block0;
                }
                continue;
            }
            equal = false;
        }
        return equal;
    }

    public boolean compareMapMessages(MapMessage message1, MapMessage message2) throws Exception {
        String name;
        int count1 = 0;
        int count2 = 0;
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        Enumeration iter1 = message1.getMapNames();
        Enumeration iter2 = message2.getMapNames();
        while (iter1.hasMoreElements()) {
            name = (String)iter1.nextElement();
            map1.put(name, message1.getObject(name));
            ++count1;
        }
        while (iter2.hasMoreElements()) {
            name = (String)iter2.nextElement();
            map2.put(name, message2.getObject(name));
            ++count2;
        }
        return count1 == count2 ? map1.equals(map2) : false;
    }

    public boolean compareObjectMessages(ObjectMessage message1, ObjectMessage message2) throws Exception {
        boolean equal = false;
        Serializable value1 = message1.getObject();
        Serializable value2 = message2.getObject();
        equal = value1 != null && value2 != null ? value1.equals(value2) : value1 == value2;
        return equal;
    }

    public boolean compareStreamMessages(StreamMessage message1, StreamMessage message2) throws Exception {
        boolean equal = true;
        while (equal) {
            Object object1 = null;
            Object object2 = null;
            int eof = 0;
            try {
                object1 = message1.readObject();
            }
            catch (MessageEOFException ignore) {
                ++eof;
            }
            try {
                object2 = message2.readObject();
            }
            catch (MessageEOFException ignore) {
                ++eof;
            }
            if (eof == 1) {
                equal = false;
                continue;
            }
            if (eof == 2) break;
            if (object1 instanceof byte[] && object2 instanceof byte[]) {
                equal = Arrays.equals((byte[])object1, (byte[])object2);
                continue;
            }
            if (object1 != null) {
                equal = object1.equals(object2);
                continue;
            }
            if (object2 == null) continue;
            equal = false;
        }
        return equal;
    }

    public boolean compareTextMessages(TextMessage message1, TextMessage message2) throws Exception {
        boolean equal = false;
        String value1 = message1.getText();
        String value2 = message2.getText();
        equal = value1 != null && value2 != null ? value1.equals(value2) : value1 == value2;
        return equal;
    }
}

