/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueSession;
import org.exolab.jmscts.core.CountingListener;
import org.exolab.jmscts.core.MessageReceiver;

class MessageBrowser
implements MessageReceiver {
    private QueueSession _session = null;
    private Queue _queue = null;
    private QueueBrowser _browser = null;
    private String _selector = null;
    private boolean _hasSelector = false;

    public MessageBrowser(QueueSession session, Queue queue) throws JMSException {
        if (session == null) {
            throw new IllegalArgumentException("Argument session is null");
        }
        if (queue == null) {
            throw new IllegalArgumentException("Argument queue is null");
        }
        this._session = session;
        this._queue = queue;
        this.getBrowser();
    }

    public MessageBrowser(QueueSession session, Queue queue, String selector) throws JMSException {
        if (session == null) {
            throw new IllegalArgumentException("Argument session is null");
        }
        if (queue == null) {
            throw new IllegalArgumentException("Argument queue is null");
        }
        this._session = session;
        this._queue = queue;
        this._selector = selector;
        this._hasSelector = true;
        this.getBrowser();
    }

    public List receive(int count, long timeout) throws JMSException {
        LinkedList<Message> result = null;
        QueueBrowser browser = this.getBrowser();
        Enumeration iter = browser.getEnumeration();
        if (count == 0) {
            ++count;
        }
        while (iter.hasMoreElements() && count > 0) {
            Message message = (Message)iter.nextElement();
            if (result == null) {
                result = new LinkedList<Message>();
            }
            result.add(message);
            --count;
        }
        return result;
    }

    public void receive(long timeout, CountingListener listener) throws JMSException {
        block2: {
            int count;
            Enumeration iter;
            block1: {
                QueueBrowser browser = this.getBrowser();
                iter = browser.getEnumeration();
                count = listener.getExpected();
                if (count != 0) break block1;
                if (!iter.hasMoreElements()) break block2;
                Message message = (Message)iter.nextElement();
                listener.onMessage(message);
                break block2;
            }
            while (iter.hasMoreElements()) {
                Message message = (Message)iter.nextElement();
                listener.onMessage(message);
                if (listener.getReceived() != count) continue;
                break;
            }
        }
    }

    public Destination getDestination() {
        return this._queue;
    }

    public String getSelector() throws JMSException {
        return this._selector;
    }

    public String getName() {
        return null;
    }

    public boolean getNoLocal() {
        return false;
    }

    public void close() throws JMSException {
        if (this._browser != null) {
            this._browser.close();
            this._browser = null;
        }
    }

    public void remove() throws JMSException {
        this.close();
    }

    private QueueBrowser getBrowser() throws JMSException {
        if (this._browser != null && !this._browser.getEnumeration().hasMoreElements()) {
            this._browser.close();
            this._browser = null;
        }
        if (this._browser == null) {
            this._browser = this._hasSelector ? this._session.createBrowser(this._queue, this._selector) : this._session.createBrowser(this._queue);
        }
        return this._browser;
    }
}

