/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.exolab.jmscts.core.MessagePopulator;

public abstract class MessageFactory {
    private final MessagePopulator _populator;

    public MessageFactory() {
        this(null);
    }

    public MessageFactory(MessagePopulator populator) {
        this._populator = populator;
    }

    public Message create(Class type) throws Exception {
        BytesMessage message = null;
        if (type.equals(BytesMessage.class)) {
            message = this.createBytesMessage();
        } else if (type.equals(MapMessage.class)) {
            message = this.createMapMessage();
        } else if (type.equals(ObjectMessage.class)) {
            message = this.createObjectMessage();
        } else if (type.equals(StreamMessage.class)) {
            message = this.createStreamMessage();
        } else if (type.equals(TextMessage.class)) {
            message = this.createTextMessage();
        } else if (type.equals(Message.class)) {
            message = this.createMessage();
        } else {
            throw new IllegalArgumentException("Argument type=" + type + " is not a valid JMS Message type");
        }
        if (this._populator != null) {
            this.populate((Message)message);
        }
        return message;
    }

    protected abstract BytesMessage createBytesMessage() throws JMSException;

    protected abstract MapMessage createMapMessage() throws JMSException;

    protected abstract Message createMessage() throws JMSException;

    protected abstract ObjectMessage createObjectMessage() throws JMSException;

    protected abstract StreamMessage createStreamMessage() throws JMSException;

    protected abstract TextMessage createTextMessage() throws JMSException;

    protected void populate(Message message) throws Exception {
        this._populator.populate(message);
    }
}

