/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Message;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractMessageTestRunner;
import org.exolab.jmscts.core.JMSTest;
import org.exolab.jmscts.core.MessageTestCase;
import org.exolab.jmscts.core.MessageTestInvoker;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestFilter;

public class MessageTestRunner
extends AbstractMessageTestRunner {
    private static final Category log = Category.getInstance((String)MessageTestRunner.class.getName());

    public MessageTestRunner(MessageTestCase test) {
        super(test);
    }

    protected void runTest(Test test, TestResult result, Class messageType) {
        Tester tester = new Tester(test, result, this.getContext(), this.getFilter(), messageType);
        result.runProtected(test, (Protectable)tester);
    }

    private class Tester
    extends MessageTestInvoker {
        public Tester(Test test, TestResult result, TestContext context, TestFilter filter, Class type) {
            super(test, result, context, filter, type);
        }

        protected void setUp(JMSTest test, TestContext context) throws Exception {
            TestContext child;
            MessageTestCase messageTest;
            super.setUp(test, context);
            if (log.isDebugEnabled()) {
                String sessionType = context.getSessionType().getName();
                String messageType = MessageTestRunner.this.getChildContext().getMessageType().getName();
                String msg = "test=" + test + " using session type=" + sessionType + ", message type=" + messageType;
                log.debug((Object)("running " + msg));
            }
            if ((messageTest = (MessageTestCase)test).shouldCreateMessage()) {
                Message message = this.create();
                child = new TestContext(context, message);
            } else {
                child = new TestContext(context, this.getMessageType());
            }
            MessageTestRunner.this.setChildContext(child);
            test.setContext(child);
        }

        protected void tearDown(JMSTest test, TestContext context) throws Exception {
            if (log.isDebugEnabled()) {
                String sessionType = context.getSessionType().getName();
                String messageType = MessageTestRunner.this.getChildContext().getMessageType().getName();
                String msg = "test=" + test + " using session type=" + sessionType + ", message type=" + messageType;
                log.debug((Object)("completed " + msg));
            }
        }
    }
}

