/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public final class MessageTypes {
    public static final MessageTypes MESSAGE;
    public static final MessageTypes BYTES;
    public static final MessageTypes MAP;
    public static final MessageTypes OBJECT;
    public static final MessageTypes STREAM;
    public static final MessageTypes TEXT;
    public static final MessageTypes ALL;
    private final Class[] _types;
    private static final Class[] MESSAGE_TYPES;

    private MessageTypes(Class type) {
        Class[] types = new Class[]{type};
        this._types = types;
    }

    private MessageTypes(Class[] types) {
        this._types = types;
    }

    public Class[] getTypes() {
        return this._types;
    }

    public static Class getType(Message message) {
        Class result = null;
        for (int i = 0; i < MESSAGE_TYPES.length; ++i) {
            if (!MESSAGE_TYPES[i].isAssignableFrom(message.getClass())) continue;
            result = MESSAGE_TYPES[i];
            break;
        }
        return result;
    }

    public static MessageTypes fromString(String name) {
        MessageTypes result = null;
        if ("all".equalsIgnoreCase(name)) {
            result = ALL;
        } else {
            name = "javax.jms." + name;
            for (int i = 0; i < MESSAGE_TYPES.length; ++i) {
                if (!MESSAGE_TYPES[i].getName().equals(name)) continue;
                result = new MessageTypes(MESSAGE_TYPES[i]);
                break;
            }
        }
        return result;
    }

    public static MessageTypes fromString(String[] names) {
        MessageTypes result = null;
        Class[] types = new Class[names.length];
        for (int i = 0; i < names.length; ++i) {
            if ("all".equalsIgnoreCase(names[i])) {
                result = ALL;
                break;
            }
            String name = "javax.jms." + names[i];
            for (int j = 0; j < MESSAGE_TYPES.length; ++j) {
                if (!MESSAGE_TYPES[j].getName().equals(name)) continue;
                types[i] = MESSAGE_TYPES[j];
                break;
            }
            if (types[i] != null) continue;
            throw new IllegalArgumentException("Invalid message type: " + names[i]);
        }
        if (result == null) {
            result = new MessageTypes(types);
        }
        return result;
    }

    public int count() {
        return this._types.length;
    }

    static {
        MESSAGE_TYPES = new Class[]{BytesMessage.class, MapMessage.class, ObjectMessage.class, StreamMessage.class, TextMessage.class, Message.class};
        MESSAGE = new MessageTypes(Message.class);
        BYTES = new MessageTypes(BytesMessage.class);
        MAP = new MessageTypes(MapMessage.class);
        OBJECT = new MessageTypes(ObjectMessage.class);
        STREAM = new MessageTypes(StreamMessage.class);
        TEXT = new MessageTypes(TextMessage.class);
        ALL = new MessageTypes(MESSAGE_TYPES);
    }
}

