/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import org.exolab.jmscts.core.DeliveryType;
import org.exolab.jmscts.core.ReceiptType;
import org.exolab.jmscts.core.TestProperties;

public class MessagingBehaviour {
    private int _deliveryMode = 2;
    private boolean _administered = true;
    private ReceiptType _receipt = ReceiptType.SYNCHRONOUS;
    private boolean _durable = false;
    private int _priority = 4;
    private long _timeout = DEFAULT_TIMEOUT;
    private static final long DEFAULT_TIMEOUT;

    public MessagingBehaviour() {
    }

    public MessagingBehaviour(DeliveryType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' is null");
        }
        this._deliveryMode = type.getDeliveryMode();
        this._administered = type.getAdministered();
        this._receipt = type.getReceiptType();
    }

    public MessagingBehaviour(MessagingBehaviour behaviour) {
        if (behaviour == null) {
            throw new IllegalArgumentException("Argument 'behaviour' is null");
        }
        this._deliveryMode = behaviour.getDeliveryMode();
        this._administered = behaviour.getAdministered();
        this._receipt = behaviour.getReceiptType();
        this._durable = behaviour.getDurable();
        this._priority = behaviour.getPriority();
        this._timeout = behaviour.getTimeout();
    }

    public void setDeliveryMode(int mode) {
        this._deliveryMode = mode;
    }

    public int getDeliveryMode() {
        return this._deliveryMode;
    }

    public void setAdministered(boolean type) {
        this._administered = type;
    }

    public boolean getAdministered() {
        return this._administered;
    }

    public void setReceiptType(ReceiptType receipt) {
        this._receipt = receipt;
    }

    public ReceiptType getReceiptType() {
        return this._receipt;
    }

    public void setDurable(boolean durable) {
        this._durable = durable;
    }

    public boolean getDurable() {
        return this._durable;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("delivery mode=");
        result.append(this._deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT");
        if (this._receipt != null) {
            result.append(", message consumer type=");
            result.append(this._receipt);
        }
        result.append(", destination type=");
        result.append(this._administered ? "administered" : "temporary");
        if (this._durable) {
            result.append(", using durable subscriber");
        }
        return result.toString();
    }

    static {
        int timeout = 2000;
        DEFAULT_TIMEOUT = TestProperties.getLong(MessagingBehaviour.class, "timeout", 2000L);
    }
}

