/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.List;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.XASession;
import org.exolab.jmscts.core.DestinationHelper;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;

public final class MessagingHelper {
    private MessagingHelper() {
    }

    public static void send(TestContext context, Destination destination, int count) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        MessagingHelper.send(context, context.getMessage(), destination, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(TestContext context, Message message, Destination destination, int count) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 'destination' is null");
        }
        MessageSender sender = SessionHelper.createSender(context, destination);
        try {
            sender.send(message, count);
            Session session = context.getSession();
            if (session.getTransacted() && !(session instanceof XASession)) {
                session.commit();
            }
        }
        finally {
            sender.close();
        }
    }

    public static Message sendReceive(TestContext context, Destination destination) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        return MessagingHelper.sendReceive(context, context.getMessage(), destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message sendReceive(TestContext context, Message message, Destination destination) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 'destination' is null");
        }
        MessageReceiver receiver = null;
        MessageSender sender = null;
        List messages = null;
        try {
            long timeout;
            receiver = SessionHelper.createReceiver(context, destination);
            sender = SessionHelper.createSender(context, destination);
            sender.send(message, 1);
            Session session = context.getSession();
            if (session.getTransacted()) {
                session.commit();
            }
            if ((messages = receiver.receive(1, timeout = context.getMessagingBehaviour().getTimeout())) == null) {
                throw new Exception("Failed to receive a message from destination=" + DestinationHelper.getName(destination));
            }
            if (messages.size() != 1) {
                throw new Exception("Expected one message from destination=" + DestinationHelper.getName(destination) + " but got " + messages.size());
            }
            if (session.getTransacted()) {
                session.commit();
            }
        }
        finally {
            if (receiver != null) {
                receiver.remove();
            }
            if (sender != null) {
                sender.close();
            }
        }
        return (Message)messages.get(0);
    }

    public static List receive(TestContext context, MessageReceiver receiver, int count) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        MessagingBehaviour behaviour = context.getMessagingBehaviour();
        if (behaviour == null) {
            throw new IllegalArgumentException("Argument context has no MessagingBehaviour instance");
        }
        return MessagingHelper.receive(receiver, count, behaviour.getTimeout());
    }

    public static List receive(MessageReceiver receiver, int count, long timeout) throws Exception {
        List result = receiver.receive(count, timeout);
        if (result == null) {
            if (count != 0) {
                throw new Exception("Failed to receive any messages from destination=" + DestinationHelper.getName(receiver.getDestination()));
            }
        } else if (result.size() != count) {
            throw new Exception("Expected " + count + " messages from destination=" + DestinationHelper.getName(receiver.getDestination()) + " but got " + result.size());
        }
        return result;
    }
}

