/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MethodCache {
    private final Class _type;
    private final HashMap _cache = new HashMap();

    public MethodCache(Class type) {
        this._type = type;
        Method[] methods = this._type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            Object value = this._cache.get(name);
            if (value == null) {
                this._cache.put(name, method);
                continue;
            }
            if (value instanceof ArrayList) {
                ((ArrayList)value).add(method);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            list.add(method);
            this._cache.put(name, list);
        }
    }

    public Method getMethod(String name) throws NoSuchMethodException {
        Object value = this._cache.get(name);
        if (value == null) {
            throw new NoSuchMethodException("Method=" + name + " not found for class=" + this._type.getName());
        }
        Method result = null;
        result = value instanceof Method ? (Method)value : (Method)((ArrayList)value).get(0);
        return result;
    }

    public Method getMethod(String name, int args) throws NoSuchMethodException {
        Object value = this._cache.get(name);
        if (value == null) {
            throw new NoSuchMethodException("Method=" + name + " not found for class=" + this._type.getName());
        }
        Method result = null;
        if (value instanceof Method) {
            result = (Method)value;
            if (result.getParameterTypes().length != args) {
                throw new NoSuchMethodException("Method=" + name + " taking parameters=" + args + " not found for class=" + this._type.getName());
            }
        } else {
            ArrayList list = (ArrayList)value;
            Iterator iter = list.iterator();
            Method next = null;
            while (iter.hasNext()) {
                next = (Method)iter.next();
                if (next.getParameterTypes().length != args) continue;
                result = next;
                break;
            }
            if (result == null) {
                throw new NoSuchMethodException("Method=" + name + " taking parameters=" + args + " not found for class=" + this._type.getName());
            }
        }
        return result;
    }
}

