/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import org.apache.log4j.Category;
import org.exolab.jmscts.core.Property;
import org.exolab.jmscts.core.types.PropertyTypeType;

public final class PropertyHelper {
    private static final Category log = Category.getInstance((Class)PropertyHelper.class);

    private PropertyHelper() {
    }

    public static Property create(String name, Object value) {
        Property result = new Property();
        PropertyTypeType type = PropertyTypeType.valueOf(value.getClass().getName());
        result.setName(name);
        result.setValue(value.toString());
        result.setType(type);
        return result;
    }

    public static Object create(Property property) {
        Object result = null;
        try {
            Class<?> type = Class.forName(property.getType().toString());
            if (type.equals(Boolean.class)) {
                result = Boolean.valueOf(property.getValue());
            } else if (type.equals(Short.class)) {
                result = Short.valueOf(property.getValue());
            } else if (type.equals(Integer.class)) {
                result = Integer.valueOf(property.getValue());
            } else if (type.equals(Long.class)) {
                result = Long.valueOf(property.getValue());
            } else if (type.equals(Float.class)) {
                result = Float.valueOf(property.getValue());
            } else if (type.equals(Double.class)) {
                result = Double.valueOf(property.getValue());
            } else if (type.equals(String.class)) {
                result = property.getValue();
            }
        }
        catch (ClassNotFoundException exception) {
            log.error((Object)exception, (Throwable)exception);
        }
        return result;
    }
}

