/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.ConnectionFactory;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.ConnectionFactoryTestCase;
import org.exolab.jmscts.core.JMSTest;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestFilter;
import org.exolab.jmscts.core.TestInvoker;
import org.exolab.jmscts.core.TestRunner;
import org.exolab.jmscts.provider.Administrator;
import org.exolab.jmscts.provider.Provider;
import org.exolab.jmscts.provider.ProviderLoader;

public class ProviderTestRunner
extends TestRunner {
    private ProviderLoader _provider = null;
    private static final Category log = Category.getInstance((Class)ProviderTestRunner.class);
    static /* synthetic */ Class class$javax$jms$QueueConnectionFactory;
    static /* synthetic */ Class class$javax$jms$TopicConnectionFactory;
    static /* synthetic */ Class class$javax$jms$XAQueueConnectionFactory;
    static /* synthetic */ Class class$javax$jms$XATopicConnectionFactory;

    public ProviderTestRunner(Test test) {
        super(test);
    }

    public void setProvider(ProviderLoader provider) {
        this._provider = provider;
    }

    protected void setUp() throws Exception {
        Provider provider = this._provider.getProvider();
        provider.initialise(this._provider.getStart());
        TestContext context = new TestContext(this.getContext(), provider.getAdministrator());
        this.setContext(context);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Provider provider = this._provider.getProvider();
        provider.cleanup(this._provider.getStop());
        this._provider = null;
    }

    protected void runTest(Test test, TestResult result) {
        ConnectionFactoryTestCase factoryTest = (ConnectionFactoryTestCase)test;
        Class[] types = factoryTest.getConnectionFactoryTypes().getTypes();
        TestContext context = this.getContext();
        TestFilter filter = this.getFilter();
        for (int i = 0; i < types.length; ++i) {
            if (filter != null && !filter.includes(types[i], test)) continue;
            Tester tester = new Tester(test, result, context, filter, types[i]);
            result.runProtected(test, (Protectable)tester);
        }
    }

    private class Tester
    extends TestInvoker {
        private final Class _type;

        public Tester(Test test, TestResult result, TestContext context, TestFilter filter, Class type) {
            super(test, result, context, filter);
            this._type = type;
        }

        protected void setUp(JMSTest test, TestContext context) throws Exception {
            ConnectionFactoryTestCase factoryTest = (ConnectionFactoryTestCase)test;
            Provider provider = ProviderTestRunner.this._provider.getProvider();
            Administrator admin = provider.getAdministrator();
            boolean queue = true;
            String factoryName = null;
            ConnectionFactory factory = null;
            try {
                if (this._type.equals(class$javax$jms$QueueConnectionFactory == null ? (class$javax$jms$QueueConnectionFactory = ProviderTestRunner.class$("javax.jms.QueueConnectionFactory")) : class$javax$jms$QueueConnectionFactory)) {
                    factoryName = admin.getQueueConnectionFactory();
                } else if (this._type.equals(class$javax$jms$TopicConnectionFactory == null ? (class$javax$jms$TopicConnectionFactory = ProviderTestRunner.class$("javax.jms.TopicConnectionFactory")) : class$javax$jms$TopicConnectionFactory)) {
                    queue = false;
                    factoryName = admin.getTopicConnectionFactory();
                } else if (this._type.equals(class$javax$jms$XAQueueConnectionFactory == null ? (class$javax$jms$XAQueueConnectionFactory = ProviderTestRunner.class$("javax.jms.XAQueueConnectionFactory")) : class$javax$jms$XAQueueConnectionFactory)) {
                    factoryName = admin.getXAQueueConnectionFactory();
                } else if (this._type.equals(class$javax$jms$XATopicConnectionFactory == null ? (class$javax$jms$XATopicConnectionFactory = ProviderTestRunner.class$("javax.jms.XATopicConnectionFactory")) : class$javax$jms$XATopicConnectionFactory)) {
                    queue = false;
                    factoryName = admin.getXATopicConnectionFactory();
                } else {
                    throw new Exception("Unsupported connection factory type=" + this._type.getName());
                }
                if (factoryName == null) {
                    throw new Exception("Provider returned null for factory of type=" + this._type.getName());
                }
                factory = (ConnectionFactory)admin.lookup(factoryName);
            }
            catch (Exception exception) {
                log.debug((Object)exception, (Throwable)exception);
                throw exception;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("running test=" + test + " using connection factory type=" + this._type.getName()));
            }
            TestContext child = new TestContext(this.getContext(), factory, this._type);
            factoryTest.setContext(child);
        }

        protected void tearDown(JMSTest test, TestContext context) throws Exception {
            if (log.isDebugEnabled()) {
                log.debug((Object)("completed running test=" + test + " using connection factory type=" + this._type.getName()));
            }
        }
    }
}

