/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.DestinationHelper;
import org.exolab.jmscts.core.JMSTest;
import org.exolab.jmscts.core.MessageTestInvoker;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.SendReceiveTestCase;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestFilter;
import org.exolab.jmscts.provider.Administrator;

public class SendReceiveTestInvoker
extends MessageTestInvoker {
    private final MessagingBehaviour _behaviour;
    private Map _destinations = null;
    private static int _seed = 0;
    private static final Category _log = Category.getInstance((Class)SendReceiveTestInvoker.class);

    public SendReceiveTestInvoker(Test test, TestResult result, TestContext context, TestFilter filter, Class messageType, MessagingBehaviour behaviour) {
        super(test, result, context, filter, messageType);
        if (!(test instanceof SendReceiveTestCase)) {
            throw new IllegalArgumentException("Argument 'test' must implement SendReceiveTestCase");
        }
        if (behaviour == null) {
            throw new IllegalArgumentException("Argument 'behaviour' is null");
        }
        this._behaviour = behaviour;
    }

    protected void setUp(JMSTest test, TestContext context) throws Exception {
        TestContext child;
        SendReceiveTestCase sendReceive;
        super.setUp(test, context);
        if (_log.isDebugEnabled()) {
            String type = context.getSessionType().getName();
            String msg = "test=" + test + " using session type=" + type + ", message type=" + this.getMessageType().getName() + ", " + this._behaviour;
            _log.debug((Object)("running " + msg));
        }
        if ((sendReceive = (SendReceiveTestCase)test).shouldCreateMessage()) {
            Message message = this.create();
            child = new TestContext(context, message, this._behaviour);
        } else {
            child = new TestContext(context, this.getMessageType(), this._behaviour);
        }
        test.setContext(child);
        String[] names = sendReceive.getDestinations();
        this._destinations = this.createDestinations(child, names);
        sendReceive.setDestinations(this._destinations);
    }

    protected void tearDown(JMSTest test, TestContext context) throws Exception {
        Session session = context.getSession();
        if (_log.isDebugEnabled()) {
            String type = context.getSessionType().getName();
            String msg = "test=" + test + " using session type=" + type + ", message type=" + this.getMessageType().getName() + ", " + this._behaviour;
            _log.debug((Object)("completed " + msg));
        }
        if (!context.isInvalid()) {
            try {
                if (session.getTransacted()) {
                    session.commit();
                }
            }
            catch (IllegalStateException ignore) {
                // empty catch block
            }
            this.destroyDestinations(this._destinations);
        }
    }

    private Map createDestinations(TestContext context, String[] names) throws Exception {
        HashMap<String, Destination> destinations = new HashMap<String, Destination>();
        Administrator admin = context.getAdministrator();
        if (names != null) {
            Destination destination = null;
            for (int i = 0; i < names.length; ++i) {
                String key = names[i];
                String name = key + ++_seed;
                try {
                    DestinationHelper.destroy(name, admin);
                    destination = DestinationHelper.create(context, name);
                }
                catch (Exception exception) {
                    _log.error((Object)exception, (Throwable)exception);
                    throw exception;
                }
                destinations.put(key, destination);
            }
        }
        return destinations;
    }

    protected void destroyDestinations(Map destinations) throws Exception {
        TestContext context = this.getContext();
        Administrator admin = context.getAdministrator();
        Iterator iter = destinations.values().iterator();
        while (iter.hasNext()) {
            try {
                Destination destination = (Destination)iter.next();
                DestinationHelper.destroy(destination, admin);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
                throw exception;
            }
        }
    }
}

