/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.JMSException;
import javax.jms.Session;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.ConnectionFactoryTypes;
import org.exolab.jmscts.core.ConnectionHelper;
import org.exolab.jmscts.core.ConnectionTestCase;
import org.exolab.jmscts.core.SessionTestCase;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.core.TestFilter;
import org.exolab.jmscts.core.TestRunner;

public class SessionTestRunner
extends TestRunner
implements ConnectionTestCase {
    private static final Category _log = Category.getInstance((Class)SessionTestRunner.class);

    public SessionTestRunner(SessionTestCase test) {
        super(test);
    }

    public ConnectionFactoryTypes getConnectionFactoryTypes() {
        return ((SessionTestCase)this.getTest()).getConnectionFactoryTypes();
    }

    public boolean startConnection() {
        return ((SessionTestCase)this.getTest()).startConnection();
    }

    public boolean setClientID() {
        return ((SessionTestCase)this.getTest()).setClientID();
    }

    protected void runTest(Test test, TestResult result) {
        SessionTestCase sessionTest = (SessionTestCase)test;
        AckType[] types = sessionTest.getAckTypes().getTypes();
        TestContext context = this.getContext();
        TestFilter filter = this.getFilter();
        if (sessionTest instanceof TestRunner) {
            ((TestRunner)((Object)sessionTest)).setFilter(filter);
        }
        for (int i = 0; i < types.length && !result.shouldStop(); ++i) {
            if (filter != null && !filter.includes(context, types[i], test)) continue;
            result.runProtected(test, (Protectable)new Tester(test, result, types[i]));
        }
    }

    protected void setUp() throws Exception {
        this.checkImplements(SessionTestCase.class);
    }

    private class Tester
    implements Protectable {
        private Test _test = null;
        private TestResult _result = null;
        private AckType _type = null;

        public Tester(Test test, TestResult result, AckType type) {
            this._test = test;
            this._result = result;
            this._type = type;
        }

        public void protect() throws Exception {
            TestContext context;
            SessionTestCase test = (SessionTestCase)this._test;
            TestContext parent = context = SessionTestRunner.this.getContext();
            if (!test.share()) {
                parent = TestContextHelper.createConnectionContext(context);
            }
            Session session = null;
            try {
                session = ConnectionHelper.createSession(parent, this._type);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
                throw exception;
            }
            String msg = null;
            if (_log.isDebugEnabled()) {
                msg = "test=" + test + " using session type=" + session.getClass().getName() + ", behaviour=" + this._type;
                _log.debug((Object)("running " + msg));
            }
            TestContext child = new TestContext(parent, session, this._type);
            test.setContext(child);
            if (test.startConnection()) {
                child.getConnection().start();
            } else {
                child.getConnection().stop();
            }
            this._test.run(this._result);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("completed " + msg));
            }
            try {
                child.close();
            }
            catch (JMSException exception) {
                _log.error((Object)exception, (Throwable)exception);
                throw exception;
            }
            if (parent != context) {
                try {
                    parent.close();
                }
                catch (Exception exception) {
                    _log.error((Object)exception, (Throwable)exception);
                    throw exception;
                }
            }
        }
    }
}

