/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.MessageTypes;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.TestCoverage;
import org.exolab.jmscts.core.TestStatistics;
import org.exolab.jmscts.provider.Administrator;

public final class TestContext {
    private TestContext _parent = null;
    private TestCoverage _coverage = null;
    private TestStatistics _statistics = null;
    private Administrator _administrator = null;
    private ConnectionFactory _factory = null;
    private Class _factoryType = null;
    private Connection _connection = null;
    private Session _session = null;
    private AckType _type = null;
    private Class _messageType;
    private Message _message = null;
    private MessagingBehaviour _behaviour = null;
    private boolean _invalid = false;

    public TestContext(TestCoverage coverage) {
        if (coverage == null) {
            throw new IllegalArgumentException("Argument 'coverage' is null");
        }
        this._coverage = coverage;
    }

    public TestContext(TestStatistics statistics) {
        if (statistics == null) {
            throw new IllegalArgumentException("Argument 'statistics' is null");
        }
        this._statistics = statistics;
    }

    public TestContext(TestContext parent, Administrator administrator) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 'parent' is null");
        }
        if (administrator == null) {
            throw new IllegalArgumentException("Argument 'administrator' is null");
        }
        this._parent = parent;
        this._administrator = administrator;
    }

    public TestContext(TestContext parent, ConnectionFactory factory, Class type) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 'parent' is null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' is null");
        }
        if (!(type.equals(QueueConnectionFactory.class) || type.equals(TopicConnectionFactory.class) || type.equals(XAQueueConnectionFactory.class) || type.equals(XATopicConnectionFactory.class))) {
            throw new IllegalArgumentException("Argument 'type' is not a valid connection factory interface");
        }
        this._parent = parent;
        this._factory = factory;
        this._factoryType = type;
    }

    public TestContext(TestContext parent, Connection connection) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 'parent' is null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        this._parent = parent;
        this._connection = connection;
    }

    public TestContext(TestContext parent, Session session, AckType type) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 'parent' is null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' is null");
        }
        this._parent = parent;
        this._session = session;
        this._type = type;
    }

    public TestContext(TestContext parent, Class messageType) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 'parent' is null");
        }
        if (messageType == null) {
            throw new IllegalArgumentException("Argument 'messageType' is null");
        }
        this._parent = parent;
        this._messageType = messageType;
    }

    public TestContext(TestContext parent, Message message) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 'parent' is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' is null");
        }
        this._parent = parent;
        this._message = message;
        this._messageType = MessageTypes.getType(message);
    }

    public TestContext(TestContext parent, Class messageType, MessagingBehaviour behaviour) {
        this(parent, messageType);
        if (behaviour == null) {
            throw new IllegalArgumentException("Argument 'behaviour' is null");
        }
        this._behaviour = behaviour;
    }

    public TestContext(TestContext parent, Message message, MessagingBehaviour behaviour) {
        this(parent, message);
        if (behaviour == null) {
            throw new IllegalArgumentException("Argument 'behaviour' is null");
        }
        this._behaviour = behaviour;
    }

    public TestCoverage getCoverage() {
        TestCoverage coverage = this._coverage;
        if (coverage == null && this._parent != null) {
            coverage = this._parent.getCoverage();
        }
        return coverage;
    }

    public TestStatistics getStatistics() {
        TestStatistics statistics = this._statistics;
        if (statistics == null && this._parent != null) {
            statistics = this._parent.getStatistics();
        }
        return statistics;
    }

    public Administrator getAdministrator() {
        Administrator administrator = this._administrator;
        if (administrator == null && this._parent != null) {
            administrator = this._parent.getAdministrator();
        }
        return administrator;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = this._factory;
        if (factory == null && this._parent != null) {
            factory = this._parent.getConnectionFactory();
        }
        return factory;
    }

    public Class getConnectionFactoryType() {
        Class type = this._factoryType;
        if (type == null && this._parent != null) {
            type = this._parent.getConnectionFactoryType();
        }
        return type;
    }

    public boolean isQueueConnectionFactory() {
        Class type = this.getConnectionFactoryType();
        return type != null && type.equals(QueueConnectionFactory.class);
    }

    public boolean isTopicConnectionFactory() {
        Class type = this.getConnectionFactoryType();
        return type != null && type.equals(TopicConnectionFactory.class);
    }

    public boolean isXAQueueConnectionFactory() {
        Class type = this.getConnectionFactoryType();
        return type != null && type.equals(XAQueueConnectionFactory.class);
    }

    public boolean isXATopicConnectionFactory() {
        Class type = this.getConnectionFactoryType();
        return type != null && type.equals(XATopicConnectionFactory.class);
    }

    public boolean isQueue() {
        return this.isQueueConnectionFactory() || this.isXAQueueConnectionFactory();
    }

    public boolean isTopic() {
        return !this.isQueue();
    }

    public Connection getConnection() {
        Connection connection = this._connection;
        if (connection == null && this._parent != null) {
            connection = this._parent.getConnection();
        }
        return connection;
    }

    public Class getConnectionType() {
        Class result = null;
        Connection connection = this.getConnection();
        if (connection != null) {
            Class type = this.getConnectionFactoryType();
            result = type.equals(QueueConnectionFactory.class) ? QueueConnection.class : (type.equals(TopicConnectionFactory.class) ? TopicConnection.class : (type.equals(XAQueueConnectionFactory.class) ? XAQueueConnection.class : XATopicConnection.class));
        }
        return result;
    }

    public Session getSession() {
        Session session = this._session;
        if (session == null && this._parent != null) {
            session = this._parent.getSession();
        }
        return session;
    }

    public Class getSessionType() {
        Class result = null;
        Session session = this.getSession();
        if (session != null) {
            Class type = this.getConnectionFactoryType();
            result = type.equals(QueueConnectionFactory.class) ? QueueSession.class : (type.equals(TopicConnectionFactory.class) ? TopicSession.class : (type.equals(XAQueueConnectionFactory.class) ? XAQueueSession.class : XATopicSession.class));
        }
        return result;
    }

    public AckType getAckType() {
        AckType type = this._type;
        if (type == null && this._parent != null) {
            type = this._parent.getAckType();
        }
        return type;
    }

    public Message getMessage() {
        Message message = this._message;
        if (message == null && this._parent != null) {
            message = this._parent.getMessage();
        }
        return message;
    }

    public Class getMessageType() {
        Class type = this._messageType;
        if (type == null && this._parent != null) {
            type = this._parent.getMessageType();
        }
        return type;
    }

    public MessagingBehaviour getMessagingBehaviour() {
        MessagingBehaviour behaviour = this._behaviour;
        if (behaviour == null && this._parent != null) {
            behaviour = this._parent.getMessagingBehaviour();
        }
        return behaviour;
    }

    public void invalidate() {
        TestContext context = this;
        while (context._session == null && context._parent != null) {
            context = context._parent;
        }
        context._session = null;
        context._invalid = true;
        context = this;
        while (context._connection == null && context._parent != null) {
            context = context._parent;
        }
        context._connection = null;
        context._invalid = true;
    }

    public boolean isInvalid() {
        TestContext context = this;
        while (!context._invalid && context._parent != null) {
            context = context._parent;
        }
        return context._invalid;
    }

    public TestContext getParent() {
        return this._parent;
    }

    public void close() throws JMSException {
        if (this._session != null) {
            this._session.close();
        }
        if (this._connection != null) {
            this._connection.close();
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String type = null;
        if (this.getConnectionFactoryType() != null) {
            type = this.isQueueConnectionFactory() ? "queue" : (this.isTopicConnectionFactory() ? "topic" : (this.isXAQueueConnectionFactory() ? "XA queue" : "XA topic"));
        }
        ConnectionFactory factory = this.getConnectionFactory();
        Connection connection = this.getConnection();
        Session session = this.getSession();
        Message message = this.getMessage();
        MessagingBehaviour behaviour = this.getMessagingBehaviour();
        if (factory != null && connection == null) {
            result.append(type);
            result.append(" connection factory");
        } else if (connection != null && session == null) {
            result.append(type);
            result.append(" connection");
        } else if (session != null) {
            result.append(type);
            result.append(" session, mode=");
            result.append(this.getAckType().toString());
            if (message != null) {
                result.append(", message type=");
                result.append(MessageTypes.getType(message).getName());
            }
            if (behaviour != null) {
                result.append(", ");
                result.append(behaviour.toString());
            }
        }
        return result.toString();
    }
}

