/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Connection;
import javax.jms.Session;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.ConnectionFactoryHelper;
import org.exolab.jmscts.core.ConnectionHelper;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.TestContext;

public final class TestContextHelper {
    private TestContextHelper() {
    }

    public static TestContext createConnectionContext(TestContext context) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (context.getConnectionFactory() == null) {
            throw new IllegalArgumentException("Argument 'context' is not a connection factory context");
        }
        Connection connection = ConnectionFactoryHelper.createConnection(context, null);
        return new TestContext(context, connection);
    }

    public static TestContext createSessionContext(TestContext context) throws Exception {
        return TestContextHelper.createSessionContext(context, true);
    }

    public static TestContext createSessionContext(TestContext context, boolean newConnection) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (context.getSession() == null) {
            throw new IllegalArgumentException("Argument 'context' is not a session context");
        }
        TestContext connection = newConnection ? TestContextHelper.createConnectionContext(context) : context.getParent();
        return TestContextHelper.createSessionContext(connection, context.getAckType());
    }

    public static TestContext createSessionContext(TestContext context, AckType type) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' is null");
        }
        if (context.getConnection() == null) {
            throw new IllegalArgumentException("Argument 'context' is not a connection context");
        }
        Session session = ConnectionHelper.createSession(context, type);
        return new TestContext(context, session, type);
    }

    public static TestContext createSendReceiveContext(TestContext context) throws Exception {
        return TestContextHelper.createSendReceiveContext(context, true);
    }

    public static TestContext createSendReceiveContext(TestContext context, boolean newConnection) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (context.getMessagingBehaviour() == null) {
            throw new IllegalArgumentException("Argument 'context' is not a send/receive context");
        }
        return TestContextHelper.createSendReceiveContext(context, newConnection, context.getMessagingBehaviour());
    }

    public static TestContext createSendReceiveContext(TestContext context, boolean newConnection, MessagingBehaviour behaviour) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (behaviour == null) {
            throw new IllegalArgumentException("Argument 'behaviour' is null");
        }
        TestContext session = TestContextHelper.createSessionContext(context, newConnection);
        return new TestContext(session, context.getMessageType(), behaviour);
    }
}

