/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.JMSTestCase;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestRunner;
import org.exolab.jmscts.report.Context;
import org.exolab.jmscts.report.Coverage;
import org.exolab.jmscts.report.CurrentTest;
import org.exolab.jmscts.report.Failure;
import org.exolab.jmscts.report.ReportHelper;
import org.exolab.jmscts.report.RequirementCoverage;
import org.exolab.jmscts.report.TestRun;
import org.exolab.jmscts.report.TestRuns;
import org.exolab.jmscts.requirements.Requirement;
import org.exolab.jmscts.requirements.Requirements;

public class TestCoverage {
    private HashMap _coverage = new HashMap();
    private HashMap _testRuns = new HashMap();
    private List _failures = new ArrayList();
    private Requirements _requirements;
    private JMSTestCase _current;
    private TestRun _currentRun;
    private static final Category log = Category.getInstance((Class)TestCoverage.class);

    public TestCoverage(Requirements requirements) {
        if (requirements == null) {
            throw new IllegalArgumentException("Argument 'requirements' is null");
        }
        this._requirements = requirements;
    }

    public synchronized void begin(JMSTestCase test) {
        String[] requirements = test.getRequirements(test.getName());
        if (requirements == null || requirements.length == 0) {
            log.error((Object)("Test=" + ReportHelper.getName(test) + " started but " + "is not associated with any requirements"));
        } else {
            this._current = test;
            this._currentRun = this.getTest(test, test.getContext());
            for (int i = 0; i < requirements.length; ++i) {
                this.addCoverage(requirements[i], test);
            }
        }
    }

    public synchronized void end(JMSTestCase test) {
        this._current = null;
        this._currentRun = null;
    }

    public synchronized void failed(Test test, Throwable cause, Throwable rootCause) {
        if (test instanceof JMSTestCase) {
            this.addFailure((JMSTestCase)test, cause, rootCause);
        } else if (test instanceof TestRunner) {
            this.addFailure((TestRunner)test, cause, rootCause);
        } else {
            this.addFailure(cause, rootCause);
        }
    }

    public synchronized void setUnsupported(String requirementId) {
        Coverage coverage = (Coverage)this._coverage.get(requirementId);
        if (coverage == null) {
            log.error((Object)("Invalid requirement identifier=" + requirementId));
        } else {
            coverage.setSupported(false);
        }
    }

    public synchronized RequirementCoverage getCoverage() {
        RequirementCoverage result = new RequirementCoverage();
        if (this._current != null) {
            CurrentTest current = new CurrentTest();
            current.setTest(ReportHelper.getName(this._current));
            current.setTestRun(this._currentRun);
            String[] requirements = this._current.getRequirements(this._current.getName());
            for (int i = 0; i < requirements.length; ++i) {
                Requirement requirement = this._requirements.getRequirement(requirements[i]);
                if (requirement == null) continue;
                current.addRequirementId(requirements[i]);
            }
            result.setCurrentTest(current);
        }
        HashSet<String> covered = new HashSet<String>();
        HashSet requirementIds = new HashSet(this._requirements.getRequirements().keySet());
        Iterator<Object> iter = this._coverage.values().iterator();
        while (iter.hasNext()) {
            Coverage coverage = (Coverage)iter.next();
            result.addCoverage(coverage);
            covered.add(coverage.getRequirementId());
        }
        requirementIds.removeAll(covered);
        iter = requirementIds.iterator();
        while (iter.hasNext()) {
            String requirementId = (String)iter.next();
            Coverage coverage = this.createCoverage(requirementId);
            result.addCoverage(coverage);
        }
        iter = this._testRuns.values().iterator();
        while (iter.hasNext()) {
            TestRuns runs = (TestRuns)iter.next();
            result.addTestRuns(runs);
        }
        iter = this._failures.iterator();
        while (iter.hasNext()) {
            result.addFailure((Failure)iter.next());
        }
        return result;
    }

    private TestRun getTest(JMSTestCase test, TestContext context) {
        TestRun result = null;
        String name = ReportHelper.getName(test);
        TestRuns testRuns = (TestRuns)this._testRuns.get(name);
        if (testRuns == null) {
            testRuns = ReportHelper.getTestRuns(test);
            this._testRuns.put(name, testRuns);
        } else if (context != null) {
            Context mapped = ReportHelper.getContext(context);
            TestRun[] runs = testRuns.getTestRun();
            for (int i = 0; i < runs.length; ++i) {
                if (!runs[i].getContext().equals(mapped)) continue;
                result = runs[i];
                break;
            }
        }
        if (result == null) {
            result = ReportHelper.getTestRun(test, context);
            testRuns.addTestRun(result);
        }
        return result;
    }

    private void addCoverage(String requirementId, JMSTestCase test) {
        Coverage coverage = this.getCoverage(requirementId, test);
        if (coverage != null) {
            String name = ReportHelper.getName(test);
            String[] tests = coverage.getTest();
            boolean found = false;
            for (int i = 0; i < tests.length; ++i) {
                if (!tests[i].equals(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                coverage.addTest(name);
            }
            int runs = coverage.getRuns();
            coverage.setRuns(runs + 1);
        }
    }

    private void addFailure(JMSTestCase test, Throwable cause, Throwable rootCause) {
        this.addFailure(test, test.getContext(), cause, rootCause);
    }

    private void addFailure(JMSTestCase test, TestContext context, Throwable cause, Throwable rootCause) {
        TestRun run = this.getTest(test, context);
        run.setFailure(ReportHelper.getFailure(cause, rootCause));
        String[] requirements = test.getRequirements(test.getName());
        if (requirements == null || requirements.length == 0) {
            log.error((Object)("Test=" + ReportHelper.getName(test) + " is not associated with any requirements"));
        } else {
            for (int i = 0; i < requirements.length; ++i) {
                Coverage coverage = this.getCoverage(requirements[i], test);
                if (coverage == null) continue;
                int failures = coverage.getFailures();
                coverage.setFailures(failures + 1);
            }
        }
    }

    private void addFailure(TestRunner runner, Throwable cause, Throwable rootCause) {
        Test test = runner.getTest();
        while (test instanceof TestRunner) {
            test = ((TestRunner)test).getTest();
        }
        if (test instanceof JMSTestCase) {
            this.addFailure((JMSTestCase)test, runner.getContext(), cause, rootCause);
        } else {
            this.addFailure(cause, rootCause);
        }
    }

    private void addFailure(Throwable cause, Throwable rootCause) {
        this._failures.add(ReportHelper.getFailure(cause, rootCause));
    }

    private Coverage getCoverage(String requirementId, JMSTestCase test) {
        Coverage coverage = (Coverage)this._coverage.get(requirementId);
        if (coverage == null) {
            Requirement requirement = this._requirements.getRequirement(requirementId);
            if (requirement != null) {
                coverage = this.createCoverage(requirementId);
                this._coverage.put(requirementId, coverage);
            } else {
                log.error((Object)("Invalid requirement identifier=" + requirementId + " used by test=" + ReportHelper.getName(test)));
            }
        }
        return coverage;
    }

    private Coverage createCoverage(String requirementId) {
        Coverage coverage = new Coverage();
        coverage.setRequirementId(requirementId);
        coverage.setRuns(0);
        coverage.setFailures(0);
        return coverage;
    }
}

