/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import org.exolab.jmscts.core.JMSTest;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.core.TestFilter;
import org.exolab.jmscts.core.TestRunner;

class TestInvoker
implements Protectable {
    private final Test _test;
    private final TestResult _result;
    private final TestContext _context;
    private final TestFilter _filter;

    public TestInvoker(Test test, TestResult result, TestContext context, TestFilter filter) {
        if (test == null) {
            throw new IllegalArgumentException("Argument 'test' is null");
        }
        if (!(test instanceof JMSTest)) {
            throw new IllegalArgumentException("Argument test must implement JMSTest");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 'result' is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        this._test = test;
        this._result = result;
        this._context = context;
        this._filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protect() throws Exception {
        JMSTest test = (JMSTest)this._test;
        TestContext context = this._context;
        boolean shared = true;
        if (test instanceof TestRunner) {
            ((TestRunner)test).setFilter(this._filter);
        }
        TestContext connection = null;
        TestContext session = null;
        if (!test.share()) {
            if (this._context.getSession() != null) {
                session = TestContextHelper.createSessionContext(this._context);
                connection = session.getParent();
                context = session;
            } else if (context.getConnection() != null) {
                context = connection = TestContextHelper.createConnectionContext(this._context);
            }
        }
        try {
            this.setUp(test, context);
            this._test.run(this._result);
            this.tearDown(test, context);
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public Test getTest() {
        return this._test;
    }

    public TestContext getContext() {
        return this._context;
    }

    protected void setUp(JMSTest test, TestContext context) throws Exception {
    }

    protected void tearDown(JMSTest test, TestContext context) throws Exception {
    }
}

