/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.HashMap;
import org.apache.log4j.Category;
import org.exolab.castor.types.Time;
import org.exolab.jmscts.core.JMSTestCase;
import org.exolab.jmscts.report.Failure;
import org.exolab.jmscts.report.ReportHelper;
import org.exolab.jmscts.report.Statistic;
import org.exolab.jmscts.report.Statistics;
import org.exolab.jmscts.report.TestRun;
import org.exolab.jmscts.report.TestRuns;
import org.exolab.jmscts.report.types.StatisticType;

public class TestStatistics {
    private HashMap _testRuns = new HashMap();
    private TestRun _current;
    private Statistics _statistics = new Statistics();
    private static final Category log = Category.getInstance((Class)TestStatistics.class);

    public synchronized void log(Statistic statistic) {
        this._current.addStatistic(statistic);
    }

    public void log(StatisticType type, int count, long start, long end) {
        long duration = end - start;
        this.log(type, count, duration);
    }

    public void log(StatisticType type, int count, long duration) {
        int oneSec = 1000;
        Statistic statistic = new Statistic();
        statistic.setType(type);
        statistic.setCount(count);
        statistic.setTime(new Time(duration));
        double seconds = 0.0;
        double rate = 0.0;
        if (duration != 0L) {
            seconds = (double)duration / 1000.0;
            rate = (double)count / seconds;
        }
        statistic.setRate(rate);
        this.log(statistic);
    }

    public synchronized Statistics getStatistics() {
        return this._statistics;
    }

    public synchronized void begin(JMSTestCase test) {
        String name = ReportHelper.getName(test);
        TestRuns runs = (TestRuns)this._testRuns.get(name);
        if (runs == null) {
            runs = ReportHelper.getTestRuns(test);
            this._testRuns.put(name, runs);
            this._statistics.addTestRuns(runs);
        }
        TestRun run = ReportHelper.getTestRun(test);
        runs.addTestRun(run);
        this._current = run;
    }

    public synchronized void end(JMSTestCase test) {
        this._current = null;
    }

    public synchronized void failed(JMSTestCase test, Throwable cause, Throwable rootCause) {
        if (this._current != null) {
            Failure failure = ReportHelper.getFailure(cause, rootCause);
            this._current.setFailure(failure);
        } else {
            log.error((Object)("Current test=" + ReportHelper.getName(test) + " is invalid. Cannot record failure: " + cause.getMessage()));
        }
    }
}

