/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TopicPublisher;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractMessageSender;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.MessageTypes;
import org.exolab.jmscts.core.MessagingBehaviour;

class TopicMessageSender
extends AbstractMessageSender {
    private static final Category _log = Category.getInstance((String)TopicMessageSender.class.getName());

    public TopicMessageSender(TopicPublisher publisher) {
        super((MessageProducer)publisher, new MessagingBehaviour());
    }

    public TopicMessageSender(TopicPublisher publisher, MessagingBehaviour behaviour) {
        super((MessageProducer)publisher, behaviour);
    }

    public void send(Message message, int count, MessagePopulator populator, long timeToLive) throws JMSException {
        MessagingBehaviour behaviour = this.getBehaviour();
        int deliveryMode = behaviour.getDeliveryMode();
        int priority = behaviour.getPriority();
        TopicPublisher publisher = (TopicPublisher)this.getProducer();
        for (int i = 0; i < count; ++i) {
            if (populator != null) {
                try {
                    populator.populate(message);
                }
                catch (Exception exception) {
                    JMSException error = new JMSException(exception.getMessage());
                    error.setLinkedException(exception);
                    throw error;
                }
            }
            if (_log.isDebugEnabled()) {
                Class type = MessageTypes.getType(message);
                _log.debug((Object)("Publishing message [message=" + type.getName() + ", topic=" + this.getDestination() + ", deliveryMode=" + deliveryMode + ", priority=" + priority + ", timeToLive=" + timeToLive + "]"));
            }
            publisher.publish(message, deliveryMode, priority, timeToLive);
        }
    }
}

