/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.jmscts.core.meta.Attribute;
import org.exolab.jmscts.core.meta.Description;

public abstract class Meta
implements Serializable {
    private String _name;
    private Description _description;
    private ArrayList _attributeList = new ArrayList();

    public void addAttribute(Attribute vAttribute) throws IndexOutOfBoundsException {
        this._attributeList.add(vAttribute);
    }

    public void addAttribute(int index, Attribute vAttribute) throws IndexOutOfBoundsException {
        this._attributeList.add(index, vAttribute);
    }

    public void clearAttribute() {
        this._attributeList.clear();
    }

    public Enumeration enumerateAttribute() {
        return new IteratorEnumeration(this._attributeList.iterator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Meta) {
            Meta temp = (Meta)obj;
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._description != null) {
                if (temp._description == null) {
                    return false;
                }
                if (!this._description.equals(temp._description)) {
                    return false;
                }
            } else if (temp._description != null) {
                return false;
            }
            if (this._attributeList != null) {
                if (temp._attributeList == null) {
                    return false;
                }
                if (!this._attributeList.equals(temp._attributeList)) {
                    return false;
                }
            } else if (temp._attributeList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Attribute getAttribute(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._attributeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Attribute)this._attributeList.get(index);
    }

    public Attribute[] getAttribute() {
        int size = this._attributeList.size();
        Attribute[] mArray = new Attribute[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Attribute)this._attributeList.get(index);
        }
        return mArray;
    }

    public int getAttributeCount() {
        return this._attributeList.size();
    }

    public Description getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public boolean removeAttribute(Attribute vAttribute) {
        boolean removed = this._attributeList.remove(vAttribute);
        return removed;
    }

    public void setAttribute(int index, Attribute vAttribute) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._attributeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._attributeList.set(index, vAttribute);
    }

    public void setAttribute(Attribute[] attributeArray) {
        this._attributeList.clear();
        for (int i = 0; i < attributeArray.length; ++i) {
            this._attributeList.add(attributeArray[i]);
        }
    }

    public void setDescription(Description description) {
        this._description = description;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

